/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.export;

import com.selima.fbi.util.IOUtil;
import com.selima.fbi.util.ResourceStorage;
import com.selima.fbi.util.RewritingOutputStream;
import com.selima.framework.threading.EventBroadcast;
import com.selima.framework.threading.EventBroadcastFactory;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

public class ExportResourceStorage
implements ResourceStorage {
    private EventBroadcast<ResourceStorage.Observer> listeners = EventBroadcastFactory.createEventBroadcast(ResourceStorage.Observer.class);
    private File targetFile;
    private File dir;

    public ExportResourceStorage(File targetFile) {
        this.targetFile = targetFile;
    }

    @Override
    public String filteredURL(String text) {
        if (text.startsWith("#") || text.startsWith("javascript:")) {
            return text;
        }
        try {
            URL url = new URL(text);
            ((ResourceStorage.Observer)this.listeners.getListener()).savingFile(url);
            URLConnection connection = url.openConnection();
            String contentType = connection.getContentType();
            String extension = this.extension(contentType);
            File savedFile = this.figureOutFile(text, extension);
            if (savedFile.exists() && savedFile.lastModified() >= connection.getLastModified()) {
                if (connection instanceof HttpURLConnection) {
                    HttpURLConnection httpConnection = (HttpURLConnection)connection;
                    httpConnection.disconnect();
                }
            } else if ("html".equals(extension)) {
                if (!url.getAuthority().startsWith("localhost")) {
                    return text;
                }
                RewritingOutputStream output = new RewritingOutputStream(new ExportResourceStorage(savedFile), savedFile);
                output.setServer(url.getProtocol() + "://" + url.getAuthority());
                IOUtil.copy(connection.getInputStream(), (OutputStream)output);
            } else {
                IOUtil.copy(connection.getInputStream(), savedFile);
            }
            return savedFile.getPath().substring(this.targetFile.getParent().length() + 1);
        }
        catch (IOException e) {
            e.printStackTrace();
            return text;
        }
    }

    @Override
    public void removeObserver(ResourceStorage.Observer observer) {
        this.listeners.removeListener((Object)observer);
    }

    @Override
    public void addObserver(ResourceStorage.Observer observer) {
        this.listeners.addListener((Object)observer);
    }

    public File getDir() {
        if (this.dir == null) {
            this.dir = new File(this.targetFile.getParentFile(), this.subtractExtension(this.targetFile) + "_resources");
            this.dir.mkdir();
        }
        return this.dir;
    }

    String subtractExtension(File f) {
        StringBuffer buf = new StringBuffer(f.getName());
        int pos = buf.lastIndexOf(".");
        if (pos != -1) {
            buf.setLength(pos);
        }
        for (int i = 0; i < buf.length(); ++i) {
            if (!Character.isWhitespace(buf.charAt(i))) continue;
            buf.setCharAt(i, '_');
        }
        return buf.toString();
    }

    String extension(String contentType) {
        if (contentType == null) {
            return "";
        }
        int start = contentType.indexOf(47);
        int end = contentType.indexOf(59);
        if (end != -1) {
            return contentType.substring(start + 1, end);
        }
        return contentType.substring(start + 1);
    }

    File figureOutFile(String url, String extension) {
        int pos = url.lastIndexOf(47);
        StringBuffer result = new StringBuffer(url.length() - pos + 9);
        result.append(url.substring(pos + 1));
        int pos2 = result.lastIndexOf(".");
        if (pos2 > 0) {
            result.setLength(pos2);
        }
        result.append(url.hashCode());
        result.append('.');
        result.append(extension);
        return new File(this.getDir(), result.toString());
    }
}

