/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.edialog;

import com.selima.fbi.CancelException;
import com.selima.fbi.plugin.PluginException;
import com.selima.fbi.plugin.u2.TaskLockException;
import com.selima.fbi.ui.MailServiceClientContext;
import com.selima.fbi.ui.MainFrame;
import com.selima.fbi.ui.MainWindow;
import com.selima.fbi.ui.common.SwingHelper;
import com.selima.fbi.ui.common.waitdlg.BasicInterrupter;
import com.selima.fbi.ui.common.waitdlg.PluginProgressModel;
import com.selima.fbi.ui.common.waitdlg.SingletonWaitingDialog;
import com.selima.fbi.ui.edialog.AbstractErrorModel;
import com.selima.framework.exception.BackendException;
import com.selima.framework.threading.BackendOperationHandle;
import com.selima.framework.threading.BackendWork;
import com.selima.framework.threading.CanceledException;
import com.selima.framework.threading.SwingOperationHandle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class TaskLockErrorModel
extends AbstractErrorModel {
    static ThreadLocal<TaskLockException> threadLocalException = new ThreadLocal();

    TaskLockErrorModel(TaskLockException e, String title, String message, String details, int width) {
        super(title, message, details, width);
        threadLocalException.set(e);
        this.details = "<html><p style='width:" + (width - 225) + "px;margin-top:0px'><b>" + e.getMessage() + "</b></p><p style='width:" + (width - 225) + "px'>You might be locked out by other users working with the FBI system in your organization. If that is the case then just wait for a while and try again. </p><p style='width:" + (width - 225) + "px;margin-bottom:10px'>If you are sure you the only one currently in then this might be a result of software or network failure. If that is the case then choose the <OBJECT classid='" + ClearLockButton.class.getName() + "'></OBJECT><BR></p></html>";
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        this.stackTrace = this.getStackTrace(e);
    }

    static class ClearLockWork
    extends BasicInterrupter
    implements BackendWork {
        final TaskLockException taskLockException;
        final MailServiceClientContext clientContext;
        final PluginProgressModel model;

        public ClearLockWork(MailServiceClientContext clientContext, TaskLockException taskLockException) {
            this.clientContext = clientContext;
            this.taskLockException = taskLockException;
            this.model = new PluginProgressModel(true);
            this.model.registerFutureStep("Clearing Task Lock ");
            SingletonWaitingDialog.showDialog(clientContext, this.model, this);
        }

        public String getName() {
            return "Clearing Task Lock";
        }

        @Override
        public void cancelBackendTask() {
            super.cancelBackendTask();
            this.taskLockException.cancel();
        }

        public void invokeBackend(BackendOperationHandle handle) throws BackendException, CanceledException, InterruptedException {
            try {
                handle.checkCancelRequest();
                this.taskLockException.releaseTaskLock();
                this.model.finishedRun();
            }
            catch (PluginException e) {
                handle.setFailure((Throwable)e);
            }
            catch (CancelException cancelException) {
                // empty catch block
            }
        }

        public void invokeSwing(SwingOperationHandle handle) {
            SingletonWaitingDialog.hideDialog();
        }
    }

    public static class ClearLockButton
    extends JButton
    implements ActionListener {
        public ClearLockButton() {
            super("Clear The Lock", SwingHelper.imageIcon("/img/16x16/actions/decrypted.png"));
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JDialog dialog = (JDialog)SwingUtilities.getWindowAncestor(this);
            dialog.setVisible(false);
            MainFrame frame = (MainFrame)dialog.getParent();
            MainWindow context = frame.getMainWindow();
            ClearLockWork lockWork = new ClearLockWork(context, threadLocalException.get());
            SwingOperationHandle handle = context.getSubmitter().submitWork((BackendWork)lockWork);
            lockWork.setTaskHandle(handle);
        }
    }
}

