/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.edialog;

import com.selima.fbi.plugin.u2.PayrollErrorException;
import com.selima.fbi.ui.edialog.AbstractErrorModel;
import java.util.List;

public class PayrollErrorModel
extends AbstractErrorModel {
    PayrollErrorModel(String title, String message, String details, PayrollErrorException error) {
        this(title, message, details, error, 450);
    }

    PayrollErrorModel(String title, String message, String details, PayrollErrorException exception, int width) {
        super(title, message, exception.getHtmlMessage(), width);
        int numOfErrors = exception.getNumOfErrors();
        StringBuilder html = new StringBuilder(numOfErrors * 30).append("<html>");
        int limit = 100;
        for (String server : exception.getServers()) {
            html.append("<b>").append(server).append("</b><ul>");
            List<String> errors = exception.getErrors(server);
            int max = Math.min(limit, errors.size());
            for (int i = 0; i < max; ++i) {
                html.append("<li>").append(errors.get(i)).append("</li>");
            }
            html.append("</ul>");
        }
        if (numOfErrors > limit) {
            html.append("<li>").append(numOfErrors - limit).append(" more errors </li>");
        }
        html.append("</html>");
        this.stackTrace = html.toString();
    }
}

