/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.edialog;

import com.selima.fbi.ui.edialog.FailureModel;
import java.io.PrintWriter;
import java.io.StringWriter;

final class DefaultFailureModel
implements FailureModel {
    private String title;
    private String message;
    private String details;
    private String twString;
    private int maximumWidth;
    Throwable tw;

    DefaultFailureModel(String title, String message, String detail, Throwable tw, int maximumWidth) {
        this.maximumWidth = maximumWidth;
        this.message = message;
        this.details = detail;
        this.title = title;
        this.tw = tw;
    }

    @Override
    public int getMaximumWidth() {
        return this.maximumWidth;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getMessage() {
        String result = this.message;
        if (result == null && this.tw != null) {
            result = "<html><b>" + this.tw.getMessage() + "</b></html>";
        }
        return result;
    }

    @Override
    public String getDetails() {
        String result = this.details;
        if (result == null && this.tw != null && this.message != null && (result = this.tw.getMessage()) != null) {
            int pos = result.indexOf("; nested exception is:");
            if (pos > 0) {
                result = result.substring(0, pos);
            }
            result = "<html>" + result.replace("\n", " <br>") + "</html>";
        }
        return result;
    }

    @Override
    public String getThrowable() {
        if (this.twString == null && this.tw != null) {
            StringWriter writer = new StringWriter(2048);
            this.tw.printStackTrace(new PrintWriter(writer));
            this.twString = writer.toString();
        }
        return this.twString;
    }
}

