/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.settings.sender;

import com.selima.fbi.sender.IModifiableSenderDetails;
import com.selima.fbi.ui.ClientContext;
import com.selima.fbi.ui.content.settings.SettingsGroup;
import com.selima.fbi.ui.content.settings.sender.AgentPanel;
import com.selima.fbi.ui.content.settings.sender.BasicsPanel;
import com.selima.fbi.ui.content.settings.sender.PrincipalPanel;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;

public class SenderDetailsPanel
extends JPanel
implements SettingsGroup,
PropertyChangeListener {
    private AgentPanel pnlAgent;
    private BasicsPanel pnlBasics;
    private PrincipalPanel pnlPrincipal;

    SenderDetailsPanel(ClientContext clientContext, IModifiableSenderDetails senderDetails) {
        this.setLayout(new BoxLayout(this, 1));
        Object oldInsets = UIManager.get("TabbedPane.contentBorderInsets");
        UIManager.put("TabbedPane.contentBorderInsets", new Insets(0, 0, 0, 0));
        JTabbedPane tabbedPane = new JTabbedPane();
        UIManager.put("TabbedPane.contentBorderInsets", oldInsets);
        this.pnlBasics = new BasicsPanel(clientContext, senderDetails);
        tabbedPane.addTab("Basics", this.pnlBasics);
        this.pnlPrincipal = new PrincipalPanel(clientContext, senderDetails);
        tabbedPane.addTab("Principal", this.pnlPrincipal);
        this.pnlAgent = new AgentPanel(clientContext, senderDetails);
        tabbedPane.addTab("Agent", this.pnlAgent);
        this.add(tabbedPane);
        this.populateUI();
        this.pnlBasics.addPropertyChangeListener("defaultDetail", this);
        this.pnlBasics.addPropertyChangeListener("label", this);
    }

    @Override
    public void populateUI() {
        this.pnlBasics.populateUI();
        this.pnlPrincipal.populateUI();
        this.pnlAgent.populateUI();
    }

    @Override
    public void populateModel() {
        this.pnlBasics.populateModel();
        this.pnlPrincipal.populateModel();
        this.pnlAgent.populateModel();
    }

    @Override
    public boolean isModified() {
        return this.pnlBasics.isModified() || this.pnlPrincipal.isModified() || this.pnlAgent.isModified();
    }

    public boolean isDefaultDetail() {
        return this.pnlBasics.isDefaultDetail();
    }

    public void setDefaultDetail(boolean state) {
        this.pnlBasics.setDefaultDetail(state);
    }

    public String getLabel() {
        return this.pnlBasics.getLabel();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
    }
}

