/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.settings.sender;

import com.selima.fbi.core.WorkHomeEnum;
import com.selima.fbi.core.YesNoEnum;
import com.selima.fbi.sender.ModifiableContact;
import com.selima.fbi.sender.ModifiableTelephone;
import com.selima.fbi.ui.ClientContext;
import com.selima.fbi.ui.content.settings.common.EnumComboBox;
import com.selima.fbi.ui.content.settings.sender.AbstractTablePanel;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.table.TableColumn;

public class PhoneNumbersPanel
extends AbstractTablePanel<ModifiableTelephone> {
    private static final int COL_NUMBER = 0;
    private static final int COL_EXTENSION = 1;
    private static final int COL_WORK_OR_HOME = 2;
    private static final int COL_IS_PREFERRED = 3;
    private static final int COL_IS_MOBILE = 4;
    private ModifiableContact contact;
    private boolean fax;

    public PhoneNumbersPanel(ClientContext clientContext, ModifiableContact contact, boolean fax) {
        super(clientContext, fax ? "Faxes" : "Telephones");
        this.contact = contact;
        this.fax = fax;
    }

    @Override
    protected int getDisplayRowCount() {
        return 3;
    }

    @Override
    protected AbstractTablePanel.CustomTable createTable() {
        return new AbstractTablePanel.CustomTable(new PhoneModel()){
            {
                TableColumn column = this.getColumnModel().getColumn(0);
                column.setPreferredWidth(100);
                column = this.getColumnModel().getColumn(1);
                column.setPreferredWidth(35);
                column = this.getColumnModel().getColumn(2);
                column.setPreferredWidth(50);
                column.setCellEditor(new DefaultCellEditor(new EnumComboBox<WorkHomeEnum>(WorkHomeEnum.class)));
                column = this.getColumnModel().getColumn(3);
                column.setPreferredWidth(50);
                column.setCellEditor(new DefaultCellEditor(new EnumComboBox<YesNoEnum>(YesNoEnum.class)));
                column = this.getColumnModel().getColumn(4);
                column.setPreferredWidth(50);
                column.setCellEditor(new DefaultCellEditor(new EnumComboBox<YesNoEnum>(YesNoEnum.class)));
            }
        };
    }

    class PhoneModel
    extends AbstractTablePanel.ListBasedTableModel<ModifiableTelephone> {
        PhoneModel() {
        }

        @Override
        List<ModifiableTelephone> acquireList() {
            if (PhoneNumbersPanel.this.fax) {
                return PhoneNumbersPanel.this.contact.getFaxes();
            }
            return PhoneNumbersPanel.this.contact.getPhones();
        }

        @Override
        void populateModel() {
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ModifiableTelephone phone = (ModifiableTelephone)this.list.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return phone.getNumber();
                }
                case 1: {
                    return phone.getExtension();
                }
                case 2: {
                    return phone.getType();
                }
                case 3: {
                    return phone.getPreferred();
                }
                case 4: {
                    return phone.getMobile();
                }
            }
            throw new IllegalArgumentException(String.valueOf(columnIndex));
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            ModifiableTelephone phone = (ModifiableTelephone)this.list.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    phone.setNumber((String)(aValue != null && aValue.toString().trim().length() == 0 ? null : (String)aValue));
                    break;
                }
                case 1: {
                    phone.setExtension((String)(aValue != null && aValue.toString().trim().length() == 0 ? null : (String)aValue));
                    break;
                }
                case 2: {
                    phone.setType((WorkHomeEnum)((Object)aValue));
                    break;
                }
                case 3: {
                    phone.setPreferred((YesNoEnum)((Object)aValue));
                    break;
                }
                case 4: {
                    phone.setMobile((YesNoEnum)((Object)aValue));
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.valueOf(columnIndex));
                }
            }
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return (PhoneNumbersPanel.this.fax ? "Fax" : "Phone") + " Number";
                }
                case 1: {
                    return "Ext";
                }
                case 2: {
                    return "Place";
                }
                case 3: {
                    return "Prefer";
                }
                case 4: {
                    return "Mobile";
                }
            }
            throw new IllegalArgumentException(String.valueOf(column));
        }

        @Override
        protected ModifiableTelephone createRow() {
            return new ModifiableTelephone();
        }
    }
}

