/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.settings.sender;

import com.selima.fbi.core.WorkHomeEnum;
import com.selima.fbi.core.YesNoEnum;
import com.selima.fbi.sender.ModifiableContact;
import com.selima.fbi.sender.ModifiableEmail;
import com.selima.fbi.ui.ClientContext;
import com.selima.fbi.ui.content.settings.common.EnumComboBox;
import com.selima.fbi.ui.content.settings.sender.AbstractTablePanel;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.table.TableColumn;

public class EmailsPanel
extends AbstractTablePanel<ModifiableEmail> {
    private static final int COL_ADDRESS = 0;
    private static final int COL_WORK_OR_HOME = 1;
    private static final int COL_IS_PREFERRED = 2;
    private ModifiableContact contact;

    public EmailsPanel(ClientContext clientContext, ModifiableContact contact) {
        super(clientContext, "E-Mails");
        this.contact = contact;
    }

    @Override
    protected int getDisplayRowCount() {
        return 3;
    }

    @Override
    protected AbstractTablePanel.CustomTable createTable() {
        return new AbstractTablePanel.CustomTable(new EmailModel()){
            {
                TableColumn column = this.getColumnModel().getColumn(0);
                column.setPreferredWidth(180);
                column = this.getColumnModel().getColumn(1);
                column.setPreferredWidth(50);
                column.setCellEditor(new DefaultCellEditor(new EnumComboBox<WorkHomeEnum>(WorkHomeEnum.class)));
                column = this.getColumnModel().getColumn(2);
                column.setPreferredWidth(50);
                column.setCellEditor(new DefaultCellEditor(new EnumComboBox<YesNoEnum>(YesNoEnum.class)));
            }
        };
    }

    class EmailModel
    extends AbstractTablePanel.ListBasedTableModel<ModifiableEmail> {
        EmailModel() {
        }

        @Override
        List<ModifiableEmail> acquireList() {
            return EmailsPanel.this.contact.getEmails();
        }

        @Override
        void populateModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ModifiableEmail email = (ModifiableEmail)this.list.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return email.getValue();
                }
                case 1: {
                    return email.getType();
                }
                case 2: {
                    return email.getPreferred();
                }
            }
            throw new IllegalArgumentException(String.valueOf(columnIndex));
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            ModifiableEmail phone = (ModifiableEmail)this.list.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    phone.setValue((String)(aValue != null && aValue.toString().trim().length() == 0 ? null : (String)aValue));
                    break;
                }
                case 1: {
                    phone.setType((WorkHomeEnum)((Object)aValue));
                    break;
                }
                case 2: {
                    phone.setPreferred((YesNoEnum)((Object)aValue));
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.valueOf(columnIndex));
                }
            }
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "E-Mail Address";
                }
                case 1: {
                    return "Place";
                }
                case 2: {
                    return "Prefer";
                }
            }
            throw new IllegalArgumentException(String.valueOf(column));
        }

        @Override
        protected ModifiableEmail createRow() {
            return new ModifiableEmail();
        }
    }
}

