/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.settings.sender;

import com.selima.fbi.sender.ModifiableContact;
import com.selima.fbi.ui.ClientContext;
import com.selima.fbi.ui.ResourceDrivenLayout;
import com.selima.fbi.ui.content.settings.SettingsGroup;
import com.selima.fbi.ui.content.settings.common.MinSizeLabel;
import com.selima.fbi.ui.content.settings.common.TextField;
import com.selima.fbi.ui.content.settings.sender.EmailsPanel;
import com.selima.fbi.ui.content.settings.sender.PhoneNumbersPanel;
import com.selima.framework.util.Util;
import java.awt.Component;
import javax.swing.JPanel;

public class ContactEditorPanel
extends JPanel
implements SettingsGroup {
    public static final String LAYOUT = "+-----------------+---------------+--------------+--------------+--------------+-------------+--------------+--+------------------------+\n| TitleLabel      |  TitleField   |  ForeLabel   | Fore1Field   |   Fore2Field | SurnameLabel| SurnameField |  |                        |\n| NONE            |  NONE         |  NONE        | NONE         |   NONE WEST  | NONE WEST   | NONE WEST    |  |                        |\n|      WEST       |       WEST    |       WEST   |      WEST    |   10  5  0 0 | 10 10 0 3   | 10 0 0 0     |  |                        |\n|  10 10 0 3      |  10 0 0 0     |  10 10 0 3   | 10 0 0  0    |     0% 0%    |             |   0% 0%      |  |                        |\n|                 |  0% 0%        |              | 0% 0%        |              |             |              |  |                        |\n+-----------------+---------------+--------------+--------------+--------------+-------------+--------------+--+------------------------+\n|  Phones BOTH          WEST 10 10 0 5 50% 50%                                                                 |Faxes BOTH       NORTH  |\n|                                                                                                              |10 10 0 10 50%  50%     |\n|                                                                                                              |                        |\n+--------------------------------------------------------------------------------------------------------------+------------------------+\n|                                                                                                              |  Emails BOTH    WEST   |\n|                                                                                                              |  10 10 10 10 50% 50%   |\n+--------------------------------------------------------------------------------------------------------------+------------------------+\n";
    private ModifiableContact contact;
    private TextField fldTitle;
    private TextField fldFore1;
    private TextField fldFore2;
    private TextField fldSurname;
    private PhoneNumbersPanel pnlPhones;
    private PhoneNumbersPanel pnlFaxes;
    private EmailsPanel pnlEmails;

    public ContactEditorPanel(ClientContext clientContext, ModifiableContact contact) {
        this(clientContext, contact, LAYOUT);
    }

    public ContactEditorPanel(ClientContext clientContext, ModifiableContact contact, String layout) {
        super(new ResourceDrivenLayout(layout));
        this.contact = contact;
        this.add((Component)new MinSizeLabel("Title"), "TitleLabel");
        this.fldTitle = new TextField(3);
        this.add((Component)this.fldTitle, "TitleField");
        this.add((Component)new MinSizeLabel("Forenames"), "ForeLabel");
        this.fldFore1 = new TextField(8);
        this.add((Component)this.fldFore1, "Fore1Field");
        this.fldFore2 = new TextField(8);
        this.add((Component)this.fldFore2, "Fore2Field");
        this.add((Component)new MinSizeLabel("Surname"), "SurnameLabel");
        this.fldSurname = new TextField(10);
        this.add((Component)this.fldSurname, "SurnameField");
        this.pnlEmails = new EmailsPanel(clientContext, contact);
        this.add((Component)this.pnlEmails, "Emails");
        this.pnlPhones = new PhoneNumbersPanel(clientContext, contact, false);
        this.add((Component)this.pnlPhones, "Phones");
        this.pnlFaxes = new PhoneNumbersPanel(clientContext, contact, true);
        this.add((Component)this.pnlFaxes, "Faxes");
    }

    @Override
    public void populateUI() {
        this.fldTitle.setText(this.contact.getTitle());
        this.fldFore1.setText(this.contact.getForename1());
        this.fldFore2.setText(this.contact.getForename2());
        this.fldSurname.setText(this.contact.getSurname());
        this.pnlPhones.populateUI();
        this.pnlFaxes.populateUI();
        this.pnlEmails.populateUI();
    }

    @Override
    public boolean isModified() {
        return !Util.equals((Object)this.fldTitle.getText(), (Object)this.contact.getTitle()) || !Util.equals((Object)this.fldFore1.getText(), (Object)this.contact.getForename1()) || !Util.equals((Object)this.fldFore2.getText(), (Object)this.contact.getForename2()) || !Util.equals((Object)this.fldSurname.getText(), (Object)this.contact.getSurname()) || this.pnlPhones.isModified() || this.pnlFaxes.isModified() || this.pnlEmails.isModified();
    }

    @Override
    public void populateModel() {
        this.contact.setTitle(this.fldTitle.getText());
        this.contact.setForename1(this.fldFore1.getText());
        this.contact.setForename2(this.fldFore2.getText());
        this.contact.setSurname(this.fldSurname.getText());
        this.pnlPhones.populateModel();
        this.pnlFaxes.populateModel();
        this.pnlEmails.populateModel();
    }
}

