/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.settings.sender;

import com.selima.fbi.CancelException;
import com.selima.fbi.sender.IModifiableSenderDetails;
import com.selima.fbi.sender.ISenderDetailsManager;
import com.selima.fbi.sender.SenderDetailsGroup;
import com.selima.fbi.storage.Transaction;
import com.selima.fbi.ui.ClientContext;
import com.selima.fbi.ui.common.TitledPanel;
import com.selima.fbi.ui.common.waitdlg.BasicInterrupter;
import com.selima.fbi.ui.common.waitdlg.StorageInterrupter;
import com.selima.fbi.ui.content.settings.SettingsGroup;
import com.selima.fbi.ui.content.settings.common.Button2;
import com.selima.fbi.ui.content.settings.sender.SenderDetailsPanel;
import com.selima.fbi.ui.edialog.FailureDialog;
import com.selima.framework.exception.BackendException;
import com.selima.framework.threading.BackendOperationHandle;
import com.selima.framework.threading.BackendWork;
import com.selima.framework.threading.CanceledException;
import com.selima.framework.threading.SwingOperationHandle;
import com.selima.framework.util.Util;
import com.selima.framework.util.logging.LogAPI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class AllSenderDetailsPanel
extends TitledPanel
implements SettingsGroup {
    private SenderDetailsTabbedPane tpSenderDetails;
    private JButton btnAdd;
    private JButton btnRemove;
    private ClientContext clientContext;

    public AllSenderDetailsPanel(ClientContext clientContext) {
        super("Sender Details", new BorderLayout());
        this.clientContext = clientContext;
        this.tpSenderDetails = new SenderDetailsTabbedPane(Collections.singletonList(clientContext.getSenderDetailsManager().create()));
        this.add((Component)this.tpSenderDetails, "Center");
        this.add((Component)new JPanel(){
            {
                this.add(AllSenderDetailsPanel.this.btnAdd = new Button2("Add New Sender Details", "/img/16x16/actions/filenew.png", new AddNewSenderDetailsAction(), 200));
                this.add(AllSenderDetailsPanel.this.btnRemove = new Button2("Remove Selected Sender Details", "/img/16x16/actions/editdelete.png", new RemoveSenderDetailsAction(), 200));
            }
        }, "South");
        this.btnAdd.setEnabled(false);
        this.btnRemove.setEnabled(false);
        this.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
    }

    @Override
    public boolean isModified() {
        return this.tpSenderDetails.isModified();
    }

    @Override
    public void populateModel() {
        this.tpSenderDetails.populateModel();
        this.save();
    }

    @Override
    public void populateUI() {
        this.btnAdd.setEnabled(false);
        this.btnRemove.setEnabled(false);
        this.populateDetailsTabs();
    }

    private void populateDetailsTabs() {
        final BasicInterrupter basicInterrupter = new BasicInterrupter();
        basicInterrupter.setTaskHandle(this.clientContext.getSubmitter().submitWork(new BackendWork(){
            List<IModifiableSenderDetails> senderDetails;
            IModifiableSenderDetails defaultSenderDetails;

            public String getName() {
                return "Loading Sender Details";
            }

            public void invokeBackend(final BackendOperationHandle handle) throws BackendException, CanceledException {
                AllSenderDetailsPanel.this.clientContext.getStatusBar().setInterrupter(new StorageInterrupter(AllSenderDetailsPanel.this.clientContext.getStorageFactory(), basicInterrupter));
                try {
                    new Transaction(AllSenderDetailsPanel.this.clientContext.getStorageFactory()).run(new Transaction.InteractionV1<CanceledException>(){

                        @Override
                        public void run() throws IOException, CancelException, CanceledException {
                            ISenderDetailsManager senderDetailsManager = AllSenderDetailsPanel.this.clientContext.getSenderDetailsManager();
                            senderDetails = new LinkedList<IModifiableSenderDetails>();
                            for (String id : senderDetailsManager.getIds()) {
                                handle.checkCancelRequest();
                                senderDetails.add(senderDetailsManager.load(id));
                            }
                            handle.checkCancelRequest();
                            if (senderDetails.isEmpty()) {
                                defaultSenderDetails = senderDetailsManager.create();
                                senderDetails.add(defaultSenderDetails);
                            } else {
                                defaultSenderDetails = senderDetailsManager.getDefault();
                            }
                        }
                    });
                }
                catch (IOException e) {
                    LogAPI.logSevere((Throwable)e);
                    handle.setFailure((Throwable)e);
                }
                catch (CancelException e) {
                    throw new CanceledException((Exception)e);
                }
                finally {
                    AllSenderDetailsPanel.this.clientContext.getStatusBar().setInterrupter(null);
                }
            }

            public void invokeSwing(SwingOperationHandle handle) {
                if (handle.getFailure() != null) {
                    if (!(handle.getFailure() instanceof CanceledException)) {
                        FailureDialog.show(AllSenderDetailsPanel.this.clientContext.getTitle(), "An error occured when loading sender details. Please contact customer support.", handle.getFailure());
                    }
                } else {
                    AllSenderDetailsPanel.this.tpSenderDetails.setSenderDetails(this.senderDetails);
                    AllSenderDetailsPanel.this.tpSenderDetails.setDefaultSenderDetails(this.defaultSenderDetails);
                }
                AllSenderDetailsPanel.this.btnAdd.setEnabled(true);
                AllSenderDetailsPanel.this.btnRemove.setEnabled(true);
            }
        }));
    }

    private void save() {
        final BasicInterrupter basicInterrupter = new BasicInterrupter();
        basicInterrupter.setTaskHandle(this.clientContext.getSubmitter().submitWork(new BackendWork(){

            public String getName() {
                return "Saving sender details";
            }

            public void invokeBackend(final BackendOperationHandle handle) throws BackendException, CanceledException {
                AllSenderDetailsPanel.this.clientContext.getStatusBar().setInterrupter(new StorageInterrupter(AllSenderDetailsPanel.this.clientContext.getStorageFactory(), basicInterrupter));
                try {
                    new Transaction(AllSenderDetailsPanel.this.clientContext.getStorageFactory()).run(new Transaction.InteractionV1<CanceledException>(){

                        @Override
                        public void run() throws IOException, CancelException, CanceledException {
                            ISenderDetailsManager senderDetailsManager = AllSenderDetailsPanel.this.clientContext.getSenderDetailsManager();
                            for (IModifiableSenderDetails senderDetails : AllSenderDetailsPanel.this.tpSenderDetails.getSenderDetails()) {
                                handle.checkCancelRequest();
                                senderDetailsManager.store(senderDetails);
                            }
                            for (IModifiableSenderDetails senderDetails : AllSenderDetailsPanel.this.tpSenderDetails.getDeletedDetails()) {
                                handle.checkCancelRequest();
                                if (senderDetails.getStoreId() == null) continue;
                                senderDetailsManager.delete(senderDetails.getStoreId());
                            }
                            senderDetailsManager.setDefault(AllSenderDetailsPanel.this.tpSenderDetails.getDefaultSenderDetails());
                            AllSenderDetailsPanel.this.tpSenderDetails.commited();
                        }
                    });
                }
                catch (IOException e) {
                    LogAPI.logSevere((Throwable)e);
                    handle.setFailure((Throwable)e);
                }
                catch (CancelException e) {
                    throw new CanceledException((Exception)e);
                }
                finally {
                    AllSenderDetailsPanel.this.clientContext.getStatusBar().setInterrupter(null);
                }
            }

            public void invokeSwing(SwingOperationHandle handle) {
                if (handle.getFailure() != null && !(handle.getFailure() instanceof CanceledException)) {
                    FailureDialog.show(AllSenderDetailsPanel.this.clientContext.getTitle(), "An error occured when saving the settings. Please contact customer support.", handle.getFailure());
                }
            }
        }));
    }

    class SenderDetailsTabbedPane
    extends JTabbedPane
    implements PropertyChangeListener {
        private List<IModifiableSenderDetails> listOfRemoved = new LinkedList<IModifiableSenderDetails>();
        private SenderDetailsGroup senderDetailsGroup = new SenderDetailsGroup();
        IModifiableSenderDetails originalDefaults;
        boolean addedDetails;

        SenderDetailsTabbedPane(List<IModifiableSenderDetails> details) {
            this.setSenderDetails(details);
        }

        @Override
        public LazySenderDetailsPanel getComponentAt(int index) {
            return (LazySenderDetailsPanel)super.getComponentAt(index);
        }

        List<IModifiableSenderDetails> getSenderDetails() {
            ArrayList<IModifiableSenderDetails> result = new ArrayList<IModifiableSenderDetails>(this.getTabCount());
            int tabCount = this.getTabCount();
            for (int i = 0; i < tabCount; ++i) {
                result.add(this.getComponentAt((int)i).senderDetails);
            }
            return result;
        }

        List<IModifiableSenderDetails> getDeletedDetails() {
            return this.listOfRemoved;
        }

        void setSenderDetails(List<IModifiableSenderDetails> currentSenderDetails) {
            int tabCount = this.getTabCount();
            for (int i = 0; i < tabCount; ++i) {
                LazySenderDetailsPanel panel = this.getComponentAt(i);
                panel.removePropertyChangeListener("tabLabel", this);
                panel.removePropertyChangeListener("defaultDetail", this);
            }
            int index = this.getSelectedIndex();
            this.removeAll();
            this.senderDetailsGroup = new SenderDetailsGroup();
            for (IModifiableSenderDetails senderDetails : currentSenderDetails) {
                this.addSenderDetails(senderDetails);
            }
            this.setSelectedIndex(Math.max(0, Math.min(this.getTabCount() - 1, index)));
            this.addedDetails = false;
            this.listOfRemoved.clear();
        }

        void addSenderDetails(IModifiableSenderDetails senderDetails) {
            LazySenderDetailsPanel panel = new LazySenderDetailsPanel(senderDetails);
            panel.addPropertyChangeListener("defaultDetail", this);
            panel.addPropertyChangeListener("tabLabel", this);
            this.senderDetailsGroup.add(senderDetails);
            this.addTab(this.tabLabel(panel), panel);
            this.addedDetails = true;
            this.setSelectedComponent(panel);
        }

        void removeSelectedDetails() {
            LazySenderDetailsPanel selectedPanel = (LazySenderDetailsPanel)this.getSelectedComponent();
            if (selectedPanel != null) {
                this.removeSenderDetails(selectedPanel.senderDetails);
            }
        }

        void removeSenderDetails(IModifiableSenderDetails detail) {
            int tabCount = this.getTabCount();
            for (int i = 0; i < tabCount; ++i) {
                LazySenderDetailsPanel panel = this.getComponentAt(i);
                if (panel.senderDetails != detail) continue;
                panel.removePropertyChangeListener("tabLabel", this);
                panel.removePropertyChangeListener("defaultDetail", this);
                this.listOfRemoved.add(detail);
                this.senderDetailsGroup.remove(detail);
                this.removeTabAt(i);
                break;
            }
        }

        void setDefaultSenderDetails(IModifiableSenderDetails details) {
            int tabCount = this.getTabCount();
            for (int i = 0; i < tabCount; ++i) {
                LazySenderDetailsPanel panel = this.getComponentAt(i);
                if (!panel.senderDetails.equals(details)) continue;
                this.originalDefaults = panel.senderDetails;
                panel.setDefaultDetail(true);
                return;
            }
            if (details != null) {
                throw new IllegalArgumentException(String.valueOf(details));
            }
            this.originalDefaults = null;
        }

        IModifiableSenderDetails getDefaultSenderDetails() {
            int tabCount = this.getTabCount();
            for (int i = 0; i < tabCount; ++i) {
                LazySenderDetailsPanel panel = this.getComponentAt(i);
                if (!panel.isDefaultDetail()) continue;
                return panel.senderDetails;
            }
            return null;
        }

        void populateModel() {
            int tabCount = this.getTabCount();
            for (int i = 0; i < tabCount; ++i) {
                this.getComponentAt(i).populateModel();
            }
        }

        void commited() {
            this.addedDetails = false;
            this.listOfRemoved.clear();
            this.originalDefaults = this.getDefaultSenderDetails();
        }

        boolean isModified() {
            if (this.addedDetails) {
                return true;
            }
            if (!this.listOfRemoved.isEmpty()) {
                return true;
            }
            if (!Util.equals((Object)this.originalDefaults, (Object)this.getDefaultSenderDetails())) {
                return true;
            }
            int tabCount = this.getTabCount();
            for (int i = 0; i < tabCount; ++i) {
                if (!this.getComponentAt(i).isModified()) continue;
                return true;
            }
            return false;
        }

        private String tabLabel(LazySenderDetailsPanel panel) {
            String result = panel.getTabLabel();
            if (result == null) {
                int index = this.indexOfComponent(panel);
                result = "New " + (index == -1 ? this.getTabCount() + 1 : index + 1);
            }
            return result;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("tabLabel".equals(evt.getPropertyName())) {
                LazySenderDetailsPanel panel = (LazySenderDetailsPanel)evt.getSource();
                this.setTitleAt(this.indexOfComponent(panel), this.tabLabel(panel));
            }
            if ("defaultDetail".equals(evt.getPropertyName()) && Boolean.TRUE.equals(evt.getNewValue())) {
                int tabCount = this.getTabCount();
                for (int i = 0; i < tabCount; ++i) {
                    LazySenderDetailsPanel panel = this.getComponentAt(i);
                    if (!panel.isDefaultDetail() || panel == evt.getSource()) continue;
                    panel.setDefaultDetail(false);
                }
            }
        }

        class LazySenderDetailsPanel
        extends JPanel
        implements AncestorListener,
        PropertyChangeListener {
            String tabLabel;
            boolean defaultDetail;
            boolean modifiedBefore;
            SenderDetailsPanel senderDetailsPanel;
            IModifiableSenderDetails senderDetails;

            LazySenderDetailsPanel(IModifiableSenderDetails senderDetails) {
                super(new BorderLayout());
                this.senderDetails = senderDetails;
                this.tabLabel = this.tabLabel(senderDetails.getLabel());
                this.addAncestorListener(this);
            }

            public String getTabLabel() {
                return this.tabLabel;
            }

            boolean isModified() {
                return this.senderDetailsPanel != null ? this.senderDetailsPanel.isModified() : this.modifiedBefore;
            }

            public boolean isDefaultDetail() {
                return this.senderDetailsPanel != null ? this.senderDetailsPanel.isDefaultDetail() : this.defaultDetail;
            }

            public void setDefaultDetail(boolean state) {
                if (this.senderDetailsPanel != null) {
                    this.senderDetailsPanel.setDefaultDetail(state);
                } else {
                    this.defaultDetail = state;
                }
            }

            void populateModel() {
                if (this.senderDetailsPanel != null) {
                    this.senderDetailsPanel.populateModel();
                }
            }

            @Override
            public void ancestorAdded(AncestorEvent event) {
                if (this.senderDetailsPanel == null) {
                    this.senderDetailsPanel = new SenderDetailsPanel(AllSenderDetailsPanel.this.clientContext, this.senderDetails);
                    this.add(this.senderDetailsPanel);
                    this.senderDetailsPanel.setDefaultDetail(this.defaultDetail);
                    this.senderDetailsPanel.addPropertyChangeListener("label", this);
                    this.senderDetailsPanel.addPropertyChangeListener("defaultDetail", this);
                }
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("label".equals(evt.getPropertyName())) {
                    String oldTabLabel = this.tabLabel;
                    this.tabLabel = this.tabLabel((String)evt.getNewValue());
                    this.firePropertyChange("tabLabel", oldTabLabel, this.tabLabel);
                } else {
                    this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
                }
            }

            private String tabLabel(String label) {
                if (!Util.isEmpty((Object)label)) {
                    return label;
                }
                String storeId = this.senderDetails.getStoreId();
                if (!Util.isEmpty((Object)storeId)) {
                    return storeId;
                }
                return null;
            }
        }
    }

    private class RemoveSenderDetailsAction
    extends AbstractAction {
        private RemoveSenderDetailsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AllSenderDetailsPanel.this.tpSenderDetails.removeSelectedDetails();
            if (AllSenderDetailsPanel.this.tpSenderDetails.getTabCount() == 0) {
                ISenderDetailsManager senderDetailsManager = AllSenderDetailsPanel.this.clientContext.getSenderDetailsManager();
                IModifiableSenderDetails newSenderDetails = senderDetailsManager.create();
                AllSenderDetailsPanel.this.tpSenderDetails.addSenderDetails(newSenderDetails);
                AllSenderDetailsPanel.this.tpSenderDetails.setDefaultSenderDetails(newSenderDetails);
            }
        }
    }

    private class AddNewSenderDetailsAction
    extends AbstractAction {
        private AddNewSenderDetailsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ISenderDetailsManager senderDetailsManager = AllSenderDetailsPanel.this.clientContext.getSenderDetailsManager();
            IModifiableSenderDetails newSenderDetails = senderDetailsManager.create();
            AllSenderDetailsPanel.this.tpSenderDetails.addSenderDetails(newSenderDetails);
        }
    }
}

