/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.settings.sender;

import com.selima.fbi.ui.ClientContext;
import com.selima.fbi.ui.ResourceDrivenLayout;
import com.selima.fbi.ui.content.settings.SettingsGroup;
import com.selima.fbi.ui.content.settings.common.Button2;
import com.selima.fbi.ui.content.settings.common.EditableTable;
import com.selima.fbi.ui.content.settings.common.MinSizeLabel;
import com.selima.fbi.ui.content.settings.common.SelectionDrivenAction;
import java.awt.Component;
import java.awt.ContainerOrderFocusTraversalPolicy;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;

public abstract class AbstractTablePanel<T>
extends JPanel
implements SettingsGroup {
    public static final String LAYOUT = "+------------+---------------------------------------+\n| Title NONE |                                       |\n| NORTHWEST  |                                       |\n| 2 0  0 5   |                                       |\n|            |                                       |\n+------------+                                       |\n| Add NONE   |         Table                         |\n| NORTHWEST  |         BOTH                          |\n| 8 0  0 5   |         0 0 0 0                       |\n|            |          10%   0%                     |\n+------------+                                       |\n| Remove NONE|                                       |\n| NORTHWEST  |                                       |\n| 8 0  0 5   |                                       |\n| 0%  100%   |                                       |\n|            |                                       |\n|            |                                       |\n+------------+---------------------------------------+\n";
    private ClientContext clientContext;
    protected CustomTable table;

    public AbstractTablePanel(ClientContext clientContext, String title) {
        super(new ResourceDrivenLayout(LAYOUT));
        this.clientContext = clientContext;
        this.table = this.createTable();
        this.add((Component)new MinSizeLabel(title), "Title");
        this.add((Component)new Button2("Add", "/img/16x16/actions/filenew.png", this.table.enhanceInsertAction(new AddRowAction())), "Add");
        this.add((Component)new Button2("Remove", "/img/16x16/actions/editdelete.png", new DeleteRowAction()), "Remove");
        this.add((Component)new JScrollPane(this.table){
            {
                this.setHorizontalScrollBarPolicy(30);
                this.setVerticalScrollBarPolicy(20);
                int width = AbstractTablePanel.this.table.getPreferredSize().width;
                int height = AbstractTablePanel.this.table.getRowHeight() * AbstractTablePanel.this.getDisplayRowCount() + AbstractTablePanel.this.table.getTableHeader().getPreferredSize().height + this.getInsets().bottom + this.getInsets().top + this.getViewport().getInsets().bottom + this.getViewport().getInsets().top;
                this.setPreferredSize(new Dimension(width, height));
            }
        }, "Table");
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusTraversalPolicy(new ContainerOrderFocusTraversalPolicy(){

            @Override
            protected boolean accept(Component component) {
                return super.accept(component) && (Button2.class.isInstance(component) || JTable.class.isInstance(component));
            }
        });
    }

    protected int getDisplayRowCount() {
        return 3;
    }

    protected abstract CustomTable createTable();

    @Override
    public void populateUI() {
        this.table.getModel().populateUI();
        this.table.getModel().setModified(false);
    }

    @Override
    public boolean isModified() {
        return this.table.getModel().isModified();
    }

    @Override
    public void populateModel() {
        this.table.getModel().pruneEmptyValue();
        this.table.getModel().populateModel();
        this.table.getModel().setModified(false);
    }

    public ClientContext getClientContext() {
        return this.clientContext;
    }

    class DeleteRowAction
    extends SelectionDrivenAction {
        DeleteRowAction() {
            super(AbstractTablePanel.this.table);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            AbstractTablePanel.this.table.getModel().deleteRow(AbstractTablePanel.this.table.getSelectionModel().getLeadSelectionIndex());
        }
    }

    class AddRowAction
    extends AbstractAction {
        AddRowAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            AbstractTablePanel.this.table.getModel().insertRow();
        }
    }

    public static abstract class ListBasedTableModel<T>
    extends CustomTableModel {
        protected List<T> list = new ArrayList<T>();

        protected ListBasedTableModel() {
        }

        @Override
        public final void populateUI() {
            this.list = this.acquireList();
            this.fireTableDataChanged();
        }

        abstract List<T> acquireList();

        @Override
        public int getRowCount() {
            return this.list.size();
        }

        @Override
        void insertRow() {
            this.list.add(this.createRow());
            int insertedRowIndex = this.list.size() - 1;
            this.fireTableRowsInserted(insertedRowIndex, insertedRowIndex);
        }

        protected abstract T createRow();

        @Override
        void deleteRow(int rowIndex) {
            if (rowIndex >= this.list.size()) {
                return;
            }
            this.list.remove(rowIndex);
            this.fireTableRowsDeleted(rowIndex, rowIndex);
        }

        public List<T> getValues() {
            return Collections.unmodifiableList(this.list);
        }

        @Override
        void pruneEmptyValue() {
            block0: for (int i = this.getRowCount() - 1; i >= 0; --i) {
                for (int j = 0; j < this.getColumnCount(); ++j) {
                    Object value = this.getValueAt(i, j);
                    if (value != null) continue block0;
                }
                this.deleteRow(i);
            }
        }
    }

    public static abstract class CustomTableModel
    extends AbstractTableModel {
        private boolean modified;

        CustomTableModel() {
            this.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent evt) {
                    this.setModified(true);
                }
            });
        }

        abstract void insertRow();

        abstract void deleteRow(int var1);

        abstract void pruneEmptyValue();

        abstract void populateUI();

        abstract void populateModel();

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        void setModified(boolean state) {
            this.modified = state;
        }

        public boolean isModified() {
            return this.modified;
        }
    }

    public static class CustomTable
    extends EditableTable {
        public CustomTable(CustomTableModel model) {
            super(model);
        }

        @Override
        public CustomTableModel getModel() {
            return (CustomTableModel)super.getModel();
        }
    }
}

