/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.settings.common;

import com.selima.fbi.ui.common.FocusFixTable;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableModel;

public abstract class EditableTable
extends FocusFixTable {
    private boolean editInsertedCell;
    protected int autoEditColumn = 0;

    public EditableTable(TableModel tableModel) {
        super(tableModel, null);
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.setSurrendersFocusOnKeystroke(true);
    }

    public Action enhanceInsertAction(Action insertAction) {
        EditInsertedCellAction result = new EditInsertedCellAction(insertAction);
        this.addMouseListener(new DoubleClicker(result));
        return result;
    }

    public void setEditInsertedCell(boolean state) {
        this.editInsertedCell = state;
    }

    @Override
    public void tableChanged(final TableModelEvent evt) {
        super.tableChanged(evt);
        if (this.editInsertedCell && evt.getType() == 1) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    final int firstRow = evt.getFirstRow();
                    EditableTable.this.getSelectionModel().addSelectionInterval(firstRow, firstRow);
                    EditableTable.this.getColumnModel().getSelectionModel().addSelectionInterval(EditableTable.this.autoEditColumn, EditableTable.this.autoEditColumn);
                    Timer timer = new Timer(100, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            EditableTable.this.editCellAt(firstRow, EditableTable.this.autoEditColumn, evt);
                            if (EditableTable.this.getSurrendersFocusOnKeystroke() && EditableTable.this.getEditorComponent() != null) {
                                EditableTable.this.getEditorComponent().requestFocusInWindow();
                            }
                        }
                    });
                    timer.setRepeats(false);
                    timer.start();
                }
            });
        }
    }

    class DoubleClicker
    extends MouseAdapter {
        final ActionListener trigger;

        DoubleClicker(ActionListener trigger) {
            this.trigger = trigger;
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            Point point;
            if (evt.getClickCount() == 2 && EditableTable.this.rowAtPoint(point = evt.getPoint()) == -1) {
                Rectangle innerBounds = EditableTable.this.getBounds();
                Insets insets = EditableTable.this.getInsets();
                innerBounds.x = insets.left;
                innerBounds.width -= insets.left + insets.right;
                innerBounds.y = insets.top;
                innerBounds.height -= insets.top + insets.bottom;
                if (innerBounds.contains(point)) {
                    this.trigger.actionPerformed(new ActionEvent(evt.getSource(), 1001, "double-click"));
                }
            }
        }
    }

    static class WrappingAction
    implements Action {
        final Action wrappedAction;

        WrappingAction(Action wrappedAction) {
            this.wrappedAction = wrappedAction;
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.wrappedAction.addPropertyChangeListener(listener);
        }

        @Override
        public Object getValue(String key) {
            return this.wrappedAction.getValue(key);
        }

        @Override
        public boolean isEnabled() {
            return this.wrappedAction.isEnabled();
        }

        @Override
        public void putValue(String key, Object value) {
            this.wrappedAction.putValue(key, value);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.wrappedAction.removePropertyChangeListener(listener);
        }

        @Override
        public void setEnabled(boolean b) {
            this.wrappedAction.setEnabled(b);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.wrappedAction.actionPerformed(e);
        }
    }

    class EditInsertedCellAction
    extends WrappingAction {
        EditInsertedCellAction(Action wrappedAction) {
            super(wrappedAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EditableTable.this.editInsertedCell = true;
            try {
                super.actionPerformed(e);
            }
            finally {
                EditableTable.this.editInsertedCell = false;
            }
        }
    }
}

