/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.settings;

import com.selima.fbi.MailServiceConfig;
import com.selima.fbi.ui.MailServiceClientContext;
import com.selima.fbi.ui.ResourceDrivenLayout;
import com.selima.fbi.ui.common.TitledPanel;
import com.selima.fbi.ui.content.settings.SettingsGroup;
import com.selima.fbi.ui.content.settings.common.HtmlLabel;
import com.selima.fbi.ui.content.settings.common.TextField;
import com.selima.fbi.user.IUser;
import com.selima.framework.util.Util;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.border.Border;

public class UserPanel
extends TitledPanel
implements SettingsGroup {
    private TextField fldUser;
    private TextField fldEmail;
    private MailServiceClientContext clientContext;
    public static final String LAYOUT = "+------------------+------------------+-----------+---------------+\n| NickLabel        |   NickField      |EmailLabel |EmailField     |\n|      3 3 3 3     | HORIZONTAL       |           |HORIZONTAL     |\n|                  | 3  0   3  3  33% |3 3 3 3    |3  0  3  3 66% |\n+------------------+------------------+-----------+---------------+\n| Information HORIZONTAL CENTER 0  0  0  0  100%  100%            |\n|                                                                 |\n+-----------------------------------------------------------------+\n";

    UserPanel(MailServiceClientContext clientContext) {
        super("User", new ResourceDrivenLayout(LAYOUT));
        this.clientContext = clientContext;
        IUser user = clientContext.getCurrentUser();
        HtmlLabel label = new HtmlLabel("<html><span style='color:olive;'>" + (user.isAgent() ? "Agent" : "User") + " <b>" + user.getLogin() + "</b> in <b>" + clientContext.getMailService().getAlias() + "</b></span></html>", 160);
        this.add((Component)label, "Information");
        label.setHorizontalAlignment(0);
        label.setToolTipText("<html><table border=0><tr><td>Directory:</td><td>" + MailServiceConfig.getBaseDir().getAbsolutePath() + "</td></tr><tr><td>Files:</td><td>" + clientContext.getStorageFactory().getName() + "</td></tr></table></html>");
        this.add((Component)new JLabel("Nick"), "NickLabel");
        this.fldUser = new TextField(4);
        this.add((Component)this.fldUser, "NickField");
        this.add((Component)new JLabel("Email"), "EmailLabel");
        this.fldEmail = new TextField(8);
        this.add((Component)this.fldEmail, "EmailField");
    }

    @Override
    public boolean isModified() {
        IUser user = this.clientContext.getCurrentUser();
        return !Util.equals((Object)this.fldUser.getText(), (Object)user.getNick()) || !Util.equals((Object)this.fldEmail.getText(), (Object)user.getEmailAddress());
    }

    @Override
    public void populateUI() {
        IUser user = this.clientContext.getCurrentUser();
        this.fldUser.setText(user.getNick());
        this.fldEmail.setText(user.getEmailAddress());
    }

    @Override
    public void populateModel() {
        IUser user = this.clientContext.getCurrentUser();
        user.setNick(this.fldUser.getText());
        user.setEmailAddress(this.fldEmail.getText());
    }

    @Override
    protected Border titleBorder(String title) {
        return BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 4, 0, 4), BorderFactory.createTitledBorder(title));
    }
}

