/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.settings;

import com.selima.fbi.CancelException;
import com.selima.fbi.ui.MailServiceClientContext;
import com.selima.fbi.ui.common.AbstractAddEmpRefAction;
import com.selima.fbi.ui.common.Constraint;
import com.selima.fbi.ui.common.SpinnerTableEditor;
import com.selima.fbi.ui.common.TitledPanel;
import com.selima.fbi.ui.content.settings.InetProxyPanel;
import com.selima.fbi.ui.content.settings.PayrollServerPanel;
import com.selima.fbi.ui.content.settings.SettingsGroup;
import com.selima.fbi.ui.content.settings.TaxRefSelection;
import com.selima.fbi.ui.content.settings.TestUniverseConnectionWork;
import com.selima.fbi.ui.content.settings.common.Button;
import com.selima.fbi.ui.content.settings.common.EditableTable;
import com.selima.fbi.ui.content.settings.common.SelectionDrivenAction;
import com.selima.fbi.user.FullReference;
import com.selima.fbi.user.IEmpRefListener;
import com.selima.fbi.user.IFullReference;
import com.selima.fbi.user.IProxySettings;
import com.selima.fbi.user.IReferenceManager;
import com.selima.fbi.user.IUser;
import com.selima.fbi.user.PayrollServerSpec;
import com.selima.framework.threading.BackendWork;
import com.selima.framework.threading.SwingOperationHandle;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class TaxReferencesPanel
extends TitledPanel
implements SettingsGroup {
    private MailServiceClientContext clientContext;
    private PayrollServerPanel payrollServerPanel;
    private InetProxyPanel inetProxyPanel;
    private TaxRefTable taxRefTable;

    public TaxReferencesPanel(MailServiceClientContext clientContext, PayrollServerPanel payrollServerPanel, InetProxyPanel inetProxyPanel) {
        super("Tax References");
        this.clientContext = clientContext;
        this.inetProxyPanel = inetProxyPanel;
        this.payrollServerPanel = payrollServerPanel;
        this.taxRefTable = new TaxRefTable();
        this.add((Component)new JScrollPane(this.taxRefTable){
            {
                int width = ((TaxReferencesPanel)TaxReferencesPanel.this).taxRefTable.getPreferredSize().width;
                int height = TaxReferencesPanel.this.taxRefTable.getRowHeight() * 3 + ((TaxReferencesPanel)TaxReferencesPanel.this).taxRefTable.getTableHeader().getPreferredSize().height + this.getInsets().bottom + this.getInsets().top + this.getViewport().getInsets().bottom + this.getViewport().getInsets().top;
                this.setPreferredSize(new Dimension(width, height));
            }
        }, Constraint.create(0, 0, 1, 3).insets(0, 5, 5, 5).fill(1).weight(1.0, 1.0));
        this.add((Component)new Button("Add", "/img/16x16/actions/filenew.png", new AddEmpRefAction()), Constraint.create(1, 0, 1, 1).insets(0, 5, 0, 5).weight(0.0, 0.0));
        this.add((Component)new Button("Remove", "/img/16x16/actions/editdelete.png", new RemoveEmpRefAction()), Constraint.create(1, 1, 1, 1).insets(5, 5, 0, 5).weight(0.0, 0.0));
        this.add((Component)new Button("Test", "/img/16x16/actions/player_play.png", new TestUniverseConnectionAction()), Constraint.create(1, 2, 1, 1).insets(5, 5, 0, 5).anchor(11).weight(0.0, 0.0));
        this.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
    }

    @Override
    public boolean isModified() {
        return this.taxRefTable.getModel().isModified();
    }

    @Override
    public void populateUI() {
        this.taxRefTable.getModel().populate();
    }

    @Override
    public void populateModel() {
        this.taxRefTable.getModel().commit();
    }

    static class TaskLockTableEditor
    extends SpinnerTableEditor {
        public TaskLockTableEditor() {
            super(0, 0, 63);
        }
    }

    static class PortTableEditor
    extends SpinnerTableEditor {
        PortTableEditor() {
            super(1, 31438, 65535);
        }
    }

    class TestUniverseConnectionAction
    extends SelectionDrivenAction {
        IFullReference ref;

        TestUniverseConnectionAction() {
            super(TaxReferencesPanel.this.taxRefTable);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.ref = TaxReferencesPanel.this.taxRefTable.getModel().fullValueOf(TaxReferencesPanel.this.taxRefTable.getSelectionModel().getLeadSelectionIndex());
            PayrollServerSpec payrollServer = this.ref.toPayrollServerSpec();
            if (TaxReferencesPanel.this.payrollServerPanel.validateServer(payrollServer)) {
                final Component component = (Component)evt.getSource();
                TestUniverseConnectionWork work = new TestUniverseConnectionWork(TaxReferencesPanel.this.clientContext, component, payrollServer){

                    @Override
                    public void invokeSwing(SwingOperationHandle handle) {
                        TestUniverseConnectionAction.this.setEnabled(true);
                        super.invokeSwing(handle);
                        component.requestFocusInWindow();
                    }
                };
                work.setTaskHandle(TaxReferencesPanel.this.clientContext.getSubmitter().submitWork((BackendWork)work));
                this.setEnabled(false);
            }
        }
    }

    class RemoveEmpRefAction
    extends SelectionDrivenAction {
        String empRef;

        RemoveEmpRefAction() {
            super(TaxReferencesPanel.this.taxRefTable);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            MailServiceClientContext context = TaxReferencesPanel.this.clientContext;
            this.empRef = TaxReferencesPanel.this.taxRefTable.getModel().valueOf(TaxReferencesPanel.this.taxRefTable.getSelectionModel().getLeadSelectionIndex());
            if (0 == JOptionPane.showConfirmDialog(SwingUtilities.getWindowAncestor((Component)evt.getSource()), "<html><H3>Remove Employer Reference</H3>" + this.empRef + "?</html>", context.getTitle(), 1, 3)) {
                TaxReferencesPanel.this.taxRefTable.getModel().remove(this.empRef);
            }
        }
    }

    class AddEmpRefAction
    extends AbstractAddEmpRefAction {
        IProxySettings proxySettings;

        AddEmpRefAction() {
            super(TaxReferencesPanel.this.clientContext);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.proxySettings = TaxReferencesPanel.this.inetProxyPanel.getProxySettings();
            super.actionPerformed(evt);
        }

        @Override
        protected boolean verifyAccess(String empRef) throws CancelException, IOException {
            return this.context.getMailService().verifyAccess(this.proxySettings, empRef);
        }

        @Override
        protected boolean goAheadFor(String empRef) {
            int index = TaxReferencesPanel.this.taxRefTable.getModel().indexOf(empRef);
            if (index != -1) {
                TaxReferencesPanel.this.taxRefTable.getSelectionModel().setSelectionInterval(index, index);
                TaxReferencesPanel.this.clientContext.getStatusBar().displayMessage("'" + empRef + "' already exists");
                return false;
            }
            return true;
        }

        @Override
        protected void verifiedSuccessfully(String empRef) {
            TaxReferencesPanel.this.taxRefTable.setEditInsertedCell(true);
            try {
                TaxReferencesPanel.this.taxRefTable.getModel().add(empRef);
            }
            finally {
                TaxReferencesPanel.this.taxRefTable.setEditInsertedCell(false);
            }
        }
    }

    class TaxReferencesModel
    extends AbstractTableModel
    implements AncestorListener,
    IEmpRefListener {
        List<IFullReference> list = new ArrayList<IFullReference>();
        boolean modified;

        TaxReferencesModel() {
            TaxReferencesPanel.this.addAncestorListener(this);
        }

        @Override
        public int getRowCount() {
            return this.list.size();
        }

        @Override
        public int getColumnCount() {
            return 8;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            IFullReference ref = this.list.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return ref.getEmpRef();
                }
                case 1: {
                    return ref.getDescription();
                }
                case 2: {
                    return ref.getHost();
                }
                case 3: {
                    return ref.getPort();
                }
                case 4: {
                    return ref.getAccount();
                }
                case 5: {
                    return ref.getUser();
                }
                case 6: {
                    return ref.getPassword();
                }
                case 7: {
                    return ref.getTaskLock();
                }
            }
            throw new IllegalArgumentException(String.valueOf(columnIndex));
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            IFullReference ref = this.list.get(rowIndex);
            this.modified = true;
            if ("".equals(aValue)) {
                aValue = null;
            }
            switch (columnIndex) {
                case 1: {
                    ref.setDescription((String)aValue);
                    break;
                }
                case 2: {
                    ref.setHost((String)aValue);
                    break;
                }
                case 3: {
                    ref.setPort((Integer)aValue);
                    break;
                }
                case 4: {
                    ref.setAccount((String)aValue);
                    break;
                }
                case 5: {
                    ref.setUser((String)aValue);
                    break;
                }
                case 6: {
                    ref.setPassword((String)aValue);
                    break;
                }
                case 7: {
                    ref.setTaskLock((Integer)aValue);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.valueOf(columnIndex));
                }
            }
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex != 0;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            String columnName = this.getColumnName(columnIndex);
            if ("Port".equals(columnName) || "Task Lock".equals(columnName)) {
                return Integer.class;
            }
            return String.class;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Reference";
                }
                case 1: {
                    return "Description";
                }
                case 2: {
                    return "Host";
                }
                case 3: {
                    return "Port";
                }
                case 4: {
                    return "Account";
                }
                case 5: {
                    return "User";
                }
                case 6: {
                    return "Password";
                }
                case 7: {
                    return "Task Lock";
                }
            }
            throw new IllegalArgumentException(String.valueOf(column));
        }

        int getPasswordColumn() {
            return this.fieldByName("Password");
        }

        int getReferenceColumn() {
            return this.fieldByName("Reference");
        }

        int getDescriptionColumn() {
            return this.fieldByName("Description");
        }

        private int fieldByName(String name) {
            for (int i = 0; i < this.getColumnCount(); ++i) {
                if (!name.equals(this.getColumnName(i))) continue;
                return i;
            }
            throw new IllegalStateException();
        }

        public void populate() {
            this.modified = false;
            IUser user = TaxReferencesPanel.this.clientContext.getCurrentUser();
            String[] empRefs = user.getEmpRef();
            ArrayList<IFullReference> newList = new ArrayList<IFullReference>(empRefs.length);
            for (String empRef : empRefs) {
                IReferenceManager referenceManager = TaxReferencesPanel.this.clientContext.getReferenceManager();
                IFullReference ref = referenceManager.getFullReference(empRef);
                newList.add(new FullReference(ref));
            }
            if (!newList.equals(this.list)) {
                this.list = newList;
                this.fireTableDataChanged();
            }
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
            TaxReferencesPanel.this.clientContext.getCurrentUser().addEmpRefListener(this);
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
            TaxReferencesPanel.this.clientContext.getCurrentUser().removeEmpRefListener(this);
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }

        @Override
        public void added(final IUser user, final String ref, final int index) {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TaxReferencesModel.this.added(user, ref, index);
                    }
                });
            } else {
                IReferenceManager referenceManager = TaxReferencesPanel.this.clientContext.getReferenceManager();
                IFullReference fullReference = referenceManager.getFullReference(ref);
                this.list.add(index, new FullReference(fullReference));
                this.fireTableRowsInserted(index, index);
            }
        }

        @Override
        public void removed(final IUser user, final String ref, final int index) {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TaxReferencesModel.this.removed(user, ref, index);
                    }
                });
            } else {
                this.list.remove(index);
                this.fireTableRowsDeleted(index, index);
            }
        }

        void commit() {
            this.modified = false;
            IUser user = TaxReferencesPanel.this.clientContext.getCurrentUser();
            user.removeEmpRefListener(this);
            HashSet<String> originals = new HashSet<String>(Arrays.asList(user.getEmpRef()));
            for (IFullReference ref : this.list) {
                IReferenceManager referenceManager;
                IFullReference original;
                if (!originals.contains(ref.getEmpRef())) {
                    user.addEmpRef(ref.getEmpRef());
                } else {
                    originals.remove(ref.getEmpRef());
                }
                if ((original = (referenceManager = TaxReferencesPanel.this.clientContext.getReferenceManager()).getFullReference(ref.getEmpRef())).equals(ref)) continue;
                original.setHost(ref.getHost());
                original.setAccount(ref.getAccount());
                original.setUser(ref.getUser());
                original.setPassword(ref.getPassword());
                original.setDescription(ref.getDescription());
                original.setPort(ref.getPort());
                original.setTaskLock(ref.getTaskLock());
            }
            for (String oldRef : originals) {
                user.removeEmpRef(oldRef);
            }
            user.addEmpRefListener(this);
        }

        int indexOf(String empRef) {
            ListIterator<IFullReference> it = this.list.listIterator();
            while (it.hasNext()) {
                if (!it.next().getEmpRef().equals(empRef)) continue;
                return it.previousIndex();
            }
            return -1;
        }

        String valueOf(int i) {
            return this.list.get(i).getEmpRef();
        }

        IFullReference fullValueOf(int i) {
            return this.list.get(i);
        }

        void add(String empRef) {
            this.modified = true;
            int index = this.list.size();
            IReferenceManager referenceManager = TaxReferencesPanel.this.clientContext.getReferenceManager();
            IFullReference ref = referenceManager.getFullReference(empRef);
            this.list.add(new FullReference(ref));
            this.fireTableRowsInserted(index, index);
        }

        void remove(String empRef) {
            this.modified = true;
            int index = this.indexOf(empRef);
            this.list.remove(index);
            this.fireTableRowsDeleted(index, index);
        }

        boolean isModified() {
            return this.modified;
        }
    }

    static class PasswordRenderer
    implements TableCellRenderer {
        JPasswordField passwordField;
        TableCellRenderer cellRenderer;

        PasswordRenderer(TableCellRenderer cellRenderer) {
            this.cellRenderer = cellRenderer;
            this.passwordField = new JPasswordField();
            this.passwordField.setBorder(null);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = this.cellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.passwordField.setText((String)value);
            this.passwordField.setForeground(component.getForeground());
            this.passwordField.setBackground(component.getBackground());
            this.passwordField.setOpaque(isSelected);
            if (hasFocus) {
                Border border = null;
                if (isSelected) {
                    border = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
                }
                if (border == null) {
                    border = UIManager.getBorder("Table.focusCellHighlightBorder");
                }
                this.passwordField.setBorder(border);
            } else {
                this.passwordField.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            }
            return this.passwordField;
        }
    }

    private static class EmpRefCellRenderer
    implements TableCellRenderer {
        final TableCellRenderer wrapped;

        EmpRefCellRenderer(TableCellRenderer renderer) {
            this.wrapped = renderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            value = "<html><b>" + value + "</b></html>";
            JComponent result = (JComponent)this.wrapped.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            result.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            return result;
        }
    }

    private static class RightAlignCellRenderer
    implements TableCellRenderer {
        final TableCellRenderer wrapped;
        final int align;

        RightAlignCellRenderer(TableCellRenderer renderer, int align) {
            this.wrapped = renderer;
            this.align = align;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel result = (JLabel)this.wrapped.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            result.setHorizontalAlignment(this.align);
            return result;
        }
    }

    class TaxRefTable
    extends EditableTable {
        TaxRefTable() {
            super(new TaxReferencesModel());
            this.setDefaultRenderer(Object.class, new RightAlignCellRenderer(this.getDefaultRenderer(Object.class), 2));
            TableColumn column = this.columnByModelIndex(this.getModel().getPasswordColumn());
            column.setCellEditor(new DefaultCellEditor(new JPasswordField()));
            column.setCellRenderer(new PasswordRenderer(this.getDefaultRenderer(Object.class)));
            column = this.columnByModelIndex(this.getModel().getReferenceColumn());
            column.setPreferredWidth(90);
            column.setMaxWidth(90);
            column.setCellRenderer(new EmpRefCellRenderer(this.getDefaultRenderer(Object.class)));
            column = this.columnByModelIndex(this.getModel().getDescriptionColumn());
            column.setPreferredWidth(200);
            column = this.columnByModelIndex(this.getModel().findColumn("Port"));
            column.setCellRenderer(new RightAlignCellRenderer(this.getDefaultRenderer(Object.class), 4));
            column.setCellEditor(new PortTableEditor());
            column = this.columnByModelIndex(this.getModel().findColumn("Task Lock"));
            column.setCellRenderer(new RightAlignCellRenderer(this.getDefaultRenderer(Object.class), 4));
            column.setCellEditor(new TaskLockTableEditor());
            this.autoEditColumn = 1;
            this.setDragEnabled(true);
            this.setTransferHandler(new TaxReferencesTransferHandler());
        }

        private TableColumn columnByModelIndex(int index) {
            for (TableColumn column : Collections.list(this.getColumnModel().getColumns())) {
                if (column.getModelIndex() != index) continue;
                return column;
            }
            throw new IllegalArgumentException(String.valueOf(index));
        }

        @Override
        public TaxReferencesModel getModel() {
            return (TaxReferencesModel)super.getModel();
        }

        private final class TaxReferencesTransferHandler
        extends TransferHandler {
            private TaxReferencesTransferHandler() {
            }

            @Override
            public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
                return false;
            }

            @Override
            public int getSourceActions(JComponent c) {
                return 1;
            }

            @Override
            public void exportAsDrag(JComponent comp, InputEvent evt, int action) {
                int row;
                MouseEvent mevt;
                int viewIndex;
                if (evt instanceof MouseEvent && (viewIndex = TaxRefTable.this.columnAtPoint((mevt = (MouseEvent)evt).getPoint())) >= 0 && viewIndex < TaxRefTable.this.getColumnCount() && (row = TaxRefTable.this.rowAtPoint(mevt.getPoint())) >= 0 && row < TaxRefTable.this.getRowCount()) {
                    super.exportAsDrag(comp, mevt, action);
                }
            }

            @Override
            protected Transferable createTransferable(JComponent c) {
                int[] rows = TaxRefTable.this.getSelectedRows();
                ArrayList<String> selection = new ArrayList<String>(rows.length);
                int column = TaxRefTable.this.getModel().getReferenceColumn();
                for (int i = 0; i < rows.length; ++i) {
                    selection.add((String)TaxRefTable.this.getValueAt(rows[i], column));
                }
                return new TaxRefSelection(selection);
            }
        }
    }
}

