/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.settings;

import com.selima.fbi.CancelException;
import com.selima.fbi.storage.Transaction;
import com.selima.fbi.ui.MailServiceClientContext;
import com.selima.fbi.ui.common.SwingHelper;
import com.selima.fbi.ui.common.ToolBar;
import com.selima.fbi.ui.common.waitdlg.BasicInterrupter;
import com.selima.fbi.ui.common.waitdlg.StorageInterrupter;
import com.selima.fbi.ui.content.AbstractClientContent;
import com.selima.fbi.ui.content.settings.InetProxyPanel;
import com.selima.fbi.ui.content.settings.PayrollServerPanel;
import com.selima.fbi.ui.content.settings.TaxReferencesPanel;
import com.selima.fbi.ui.content.settings.UserPanel;
import com.selima.fbi.ui.content.settings.sender.AllSenderDetailsPanel;
import com.selima.fbi.ui.edialog.FailureDialog;
import com.selima.fbi.user.IUser;
import com.selima.framework.threading.BackendOperationHandle;
import com.selima.framework.threading.BackendWork;
import com.selima.framework.threading.CanceledException;
import com.selima.framework.threading.SwingOperationHandle;
import com.selima.framework.util.logging.LogAPI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class SettingsContent
extends AbstractClientContent {
    private UserPanel userPanel;
    private InetProxyPanel proxyPanel;
    private PayrollServerPanel payrollServerPanel;
    private TaxReferencesPanel taxReferencesPanel;
    private AllSenderDetailsPanel senderDetailsPanel;

    public SettingsContent(MailServiceClientContext context) {
        super(context, "/img/32x32/actions/configure.png", "Preparing for Configuration");
        this.initComponents();
        new OnDisplaySynchronizer();
    }

    @Override
    public String getContentName() {
        return "Settings";
    }

    @Override
    public ToolBar getToolBar() {
        return null;
    }

    @Override
    public String getDescription() {
        return "Settings & Configuration";
    }

    @Override
    public String getHelpTopic() {
        return "content.context-help.settings";
    }

    @Override
    public boolean canClose() {
        if (this.isModified()) {
            switch (JOptionPane.showConfirmDialog(SwingUtilities.getWindowAncestor(this), "Do you want to save the changes?", this.getClientContext().getTitle(), 1, 2)) {
                case 0: {
                    this.populateModel();
                }
                case 1: {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private void initComponents() {
        this.setLayout(new BoxLayout(this, 1));
        this.add(new JScrollPane(new JPanel(){
            {
                Dimension size;
                this.setLayout(new BoxLayout(this, 1));
                Box topBox = new Box(0);
                topBox.add(SettingsContent.this.userPanel = new UserPanel(SettingsContent.this.getClientContext()));
                topBox.add(SettingsContent.this.proxyPanel = new InetProxyPanel(SettingsContent.this.getClientContext()));
                topBox.add(SettingsContent.this.payrollServerPanel = new PayrollServerPanel(SettingsContent.this.getClientContext()));
                topBox.add(Box.createRigidArea(new Dimension(5, 5)));
                int maxHeight = 0;
                for (Component c : Arrays.asList(SettingsContent.this.userPanel, SettingsContent.this.proxyPanel, SettingsContent.this.payrollServerPanel)) {
                    size = c.getMaximumSize();
                    if (size.height <= maxHeight) continue;
                    maxHeight = size.height;
                }
                for (Component c : Arrays.asList(SettingsContent.this.userPanel, SettingsContent.this.proxyPanel, SettingsContent.this.payrollServerPanel)) {
                    size = c.getMaximumSize();
                    size.height = maxHeight;
                    c.setMaximumSize(size);
                }
                this.add(topBox);
                this.add(SettingsContent.this.taxReferencesPanel = new TaxReferencesPanel(SettingsContent.this.getClientContext(), SettingsContent.this.payrollServerPanel, SettingsContent.this.proxyPanel));
                this.add(SettingsContent.this.senderDetailsPanel = new AllSenderDetailsPanel(SettingsContent.this.getClientContext()));
                this.add(new ControlPanel());
            }
        }, 20, 31));
    }

    boolean isModified() {
        return this.userPanel.isModified() || this.proxyPanel.isModified() || this.payrollServerPanel.isModified() || this.taxReferencesPanel.isModified() || this.senderDetailsPanel.isModified();
    }

    void populateUI() {
        this.userPanel.populateUI();
        this.proxyPanel.populateUI();
        this.payrollServerPanel.populateUI();
        this.taxReferencesPanel.populateUI();
        this.senderDetailsPanel.populateUI();
    }

    void populateModel() {
        this.userPanel.populateModel();
        this.proxyPanel.populateModel();
        this.payrollServerPanel.populateModel();
        this.taxReferencesPanel.populateModel();
        SaveUserWork saveUserWork = new SaveUserWork();
        saveUserWork.setTaskHandle(this.getClientContext().getSubmitter().submitWork((BackendWork)saveUserWork));
        this.senderDetailsPanel.populateModel();
    }

    class ControlPanel
    extends JPanel {
        ControlPanel() {
            super(new FlowLayout(1, 20, 5));
            this.add(new JButton("Apply", SwingHelper.imageIcon("/img/16x16/actions/button_ok.png")){
                {
                    super(x0, x1);
                    this.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent evt) {
                            SettingsContent.this.populateModel();
                        }
                    });
                }
            });
            this.add(new JButton("Cancel", SwingHelper.imageIcon("/img/16x16/actions/cancel.png")){
                {
                    super(x0, x1);
                    this.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            SettingsContent.this.populateUI();
                        }
                    });
                }
            });
        }

        @Override
        public Dimension getMaximumSize() {
            Dimension maxSize = super.getMaximumSize();
            maxSize.height = super.getPreferredSize().height;
            return maxSize;
        }
    }

    class SaveUserWork
    extends BasicInterrupter
    implements BackendWork {
        SaveUserWork() {
        }

        public String getName() {
            return "Saving user settings";
        }

        public void invokeBackend(final BackendOperationHandle handle) throws CanceledException {
            SettingsContent.this.getClientContext().getStatusBar().setInterrupter(new StorageInterrupter(SettingsContent.this.getClientContext().getStorageFactory(), this));
            try {
                new Transaction(SettingsContent.this.getClientContext().getStorageFactory()).run(new Transaction.InteractionV1<CanceledException>(){

                    @Override
                    public void run() throws IOException, CancelException, CanceledException {
                        handle.checkCancelRequest();
                        IUser user = SettingsContent.this.getClientContext().getCurrentUser();
                        SettingsContent.this.getClientContext().getReferenceManager().save();
                        handle.checkCancelRequest();
                        SettingsContent.this.getClientContext().getUserManager().saveUser(user);
                    }
                });
            }
            catch (IOException e) {
                LogAPI.logSevere((Throwable)e);
                handle.setFailure((Throwable)e);
            }
            catch (CancelException e) {
                throw new CanceledException((Exception)e);
            }
            finally {
                SettingsContent.this.getClientContext().getStatusBar().setInterrupter(null);
            }
        }

        public void invokeSwing(SwingOperationHandle handle) {
            if (handle.getFailure() != null && !(handle.getFailure() instanceof CanceledException)) {
                FailureDialog.show(SettingsContent.this.getClientContext().getTitle(), "An error occured when saving the settings. Please contact customer support.", handle.getFailure());
            }
        }
    }

    class LayoutUpdater
    implements AncestorListener {
        LayoutUpdater() {
            SettingsContent.this.addAncestorListener(this);
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
            SettingsContent.this.removeAll();
            SettingsContent.this.initComponents();
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }
    }

    class OnDisplaySynchronizer
    implements AncestorListener {
        OnDisplaySynchronizer() {
            SettingsContent.this.addAncestorListener(this);
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
            SettingsContent.this.populateUI();
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }
    }
}

