/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.settings;

import com.selima.fbi.CancelException;
import com.selima.fbi.ui.MailServiceClientContext;
import com.selima.fbi.ui.ResourceDrivenLayout;
import com.selima.fbi.ui.common.TitledPanel;
import com.selima.fbi.ui.common.waitdlg.BasicInterrupter;
import com.selima.fbi.ui.common.waitdlg.NetworkConnectionCheckModel;
import com.selima.fbi.ui.common.waitdlg.SingletonWaitingDialog;
import com.selima.fbi.ui.content.settings.SettingsGroup;
import com.selima.fbi.ui.content.settings.common.AbstractTestButton;
import com.selima.fbi.ui.content.settings.common.FirstModificationFilter;
import com.selima.fbi.ui.content.settings.common.FormattedField;
import com.selima.fbi.ui.content.settings.common.MinSizeLabel;
import com.selima.fbi.ui.content.settings.common.PasswordField;
import com.selima.fbi.ui.content.settings.common.TextField;
import com.selima.fbi.ui.edialog.FailureDialog;
import com.selima.fbi.user.IProxySettings;
import com.selima.fbi.user.IUser;
import com.selima.fbi.user.ProxySettings;
import com.selima.framework.threading.BackendOperationHandle;
import com.selima.framework.threading.BackendWork;
import com.selima.framework.threading.CanceledException;
import com.selima.framework.threading.SwingOperationHandle;
import com.selima.framework.util.Util;
import com.selima.framework.util.logging.LogAPI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class InetProxyPanel
extends TitledPanel
implements SettingsGroup {
    public static final String LAYOUT = "+------------+------------+-----------+-----------+----------+\n| HostLabel  | HostField  | PortLabel | PortField |          |\n| NONE       | HORIZONTAL | NONE      | HORIZONTAL|          |\n| WEST       |            | WEST      | WEST      |          |\n| 0 0 3 3    | 0 0 3 3    | 0 5 3 3   | 0 0 3 3   |          |\n|            | 50%        | 0%        | 50%       |          |\n|            |            |           |           |          |\n+------------+------------+-----------+-----------+----------+\n| UserLabel  | UserField  | PassLabel | PassField | TestBtn  |\n| NONE       | HORIZONTAL | NONE      | HORIZONTAL| NONE     |\n| WEST       |            | WEST      |           | WEST     |\n| 3 0 0 3    | 3 0 0 3    | 3 5 0 3   | 3 0 0 3   | 3 3 0 0  |\n|            | 50%        |           | 50%       | 0%       |\n|            |            |           |           |          |\n+------------+------------+-----------+-----------+----------+\n";
    private MailServiceClientContext clientContext;
    private TextField fldProxyHost;
    private TextField fldProxyUser;
    private FormattedField ftfProxyPort;
    private PasswordField fldProxyPassword;
    private ProxyTestButton btnProxyTest;

    InetProxyPanel(MailServiceClientContext clientContext) {
        super("Proxy", new ResourceDrivenLayout(LAYOUT));
        this.clientContext = clientContext;
        this.add((Component)new MinSizeLabel("Host"), "HostLabel");
        this.fldProxyHost = new TextField(8);
        this.add((Component)this.fldProxyHost, "HostField");
        this.add((Component)new MinSizeLabel("Port"), "PortLabel");
        this.ftfProxyPort = new FormattedField();
        this.add((Component)this.ftfProxyPort, "PortField");
        this.add((Component)new MinSizeLabel("User"), "UserLabel");
        this.fldProxyUser = new TextField(8);
        this.add((Component)this.fldProxyUser, "UserField");
        this.add((Component)new MinSizeLabel("Password"), "PassLabel");
        this.fldProxyPassword = new PasswordField(5);
        this.add((Component)this.fldProxyPassword, "PassField");
        this.btnProxyTest = new ProxyTestButton();
        this.add((Component)this.btnProxyTest, "TestBtn");
        new FirstModificationFilter(this.btnProxyTest, this.fldProxyHost, this.fldProxyUser, this.fldProxyPassword, this.ftfProxyPort);
    }

    @Override
    public boolean isModified() {
        IUser user = this.clientContext.getCurrentUser();
        return !Util.equals((Object)this.fldProxyHost.getText(), (Object)user.getProxySettings().getProxyHost()) || !Util.equals((Object)this.fldProxyUser.getText(), (Object)user.getProxySettings().getProxyUser()) || !Util.equals((Object)this.fldProxyPassword.getPasswordText(), (Object)user.getProxySettings().getProxyPassword()) || !Util.equals((Object)this.ftfProxyPort.getValue(), (Object)user.getProxySettings().getProxyPort());
    }

    @Override
    public void populateUI() {
        IUser user = this.clientContext.getCurrentUser();
        IProxySettings proxy = user.getProxySettings();
        this.fldProxyHost.setText(proxy.getProxyHost());
        this.ftfProxyPort.setValue(proxy.getProxyPort());
        this.fldProxyUser.setText(proxy.getProxyUser());
        this.fldProxyPassword.setText(proxy.getProxyPassword());
        this.btnProxyTest.displayValid();
    }

    @Override
    public void populateModel() {
        IUser user = this.clientContext.getCurrentUser();
        this.populateProxy(user.getProxySettings());
    }

    IProxySettings getProxySettings() {
        ProxySettings result = new ProxySettings();
        result.setProxyUser(this.fldProxyUser.getText());
        result.setProxyHost(this.fldProxyHost.getText());
        result.setProxyPassword(this.fldProxyPassword.getPasswordText());
        result.setProxyPort(this.ftfProxyPort.getInteger());
        return result;
    }

    private IProxySettings populateProxy(IProxySettings proxy) {
        proxy.setProxyUser(this.fldProxyUser.getText());
        proxy.setProxyHost(this.fldProxyHost.getText());
        proxy.setProxyPassword(this.fldProxyPassword.getPasswordText());
        proxy.setProxyPort(this.ftfProxyPort.getInteger());
        return proxy;
    }

    void testConnection() {
        this.btnProxyTest.setEnabled(false);
        this.ftfProxyPort.setEnabled(false);
        this.fldProxyHost.setEnabled(false);
        this.fldProxyUser.setEnabled(false);
        this.fldProxyPassword.setEnabled(false);
        this.clientContext.getSubmitter().submitWork((BackendWork)new NetworkTestWork());
    }

    @Override
    protected Border titleBorder(String title) {
        return BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 4, 0, 4), BorderFactory.createTitledBorder(title));
    }

    private final class NetworkTestWork
    extends BasicInterrupter
    implements BackendWork {
        NetworkConnectionCheckModel progressModel = new NetworkConnectionCheckModel();

        NetworkTestWork() {
            SingletonWaitingDialog.showDialog(InetProxyPanel.this.clientContext, this.progressModel, this);
        }

        public String getName() {
            return "Testing Network Connection";
        }

        public void invokeBackend(BackendOperationHandle handle) throws CanceledException {
            try {
                handle.setResult((Object)InetProxyPanel.this.clientContext.getMailService().testConnection(InetProxyPanel.this.populateProxy(new ProxySettings())));
                this.progressModel.finished();
            }
            catch (IOException e) {
                handle.setFailure((Throwable)e);
            }
            catch (CancelException e) {
                throw new CanceledException((Exception)e);
            }
        }

        public void invokeSwing(SwingOperationHandle handle) {
            SingletonWaitingDialog.hideDialog();
            InetProxyPanel.this.btnProxyTest.setEnabled(true);
            InetProxyPanel.this.fldProxyPassword.setEnabled(true);
            InetProxyPanel.this.fldProxyUser.setEnabled(true);
            InetProxyPanel.this.fldProxyHost.setEnabled(true);
            InetProxyPanel.this.ftfProxyPort.setEnabled(true);
            if (handle.getResult() == Boolean.TRUE) {
                InetProxyPanel.this.btnProxyTest.displayValid();
                InetProxyPanel.this.clientContext.getStatusBar().displayMessage("Network Connection tested successfuly.");
                JOptionPane.showConfirmDialog(SwingUtilities.getWindowAncestor(InetProxyPanel.this.btnProxyTest), "Network Connection tested successfully", InetProxyPanel.this.clientContext.getTitle(), -1, 1);
            } else if (!(handle.getFailure() instanceof CanceledException)) {
                InetProxyPanel.this.btnProxyTest.displayUntested();
                InetProxyPanel.this.clientContext.getStatusBar().displayMessage("HMRC server is not reachable.");
                Throwable tw = handle.getFailure();
                if (tw != null) {
                    FailureDialog.show(InetProxyPanel.this.clientContext.getTitle(), "<b>Unexpected failure connecting HMRC server</b>", tw);
                    LogAPI.logSevere((Throwable)tw);
                } else {
                    JOptionPane.showConfirmDialog(SwingUtilities.getWindowAncestor(InetProxyPanel.this.btnProxyTest), "<html>HMRC server is <b>not</b> reachable.</html>", InetProxyPanel.this.clientContext.getTitle(), -1, 2);
                }
            }
            InetProxyPanel.this.btnProxyTest.requestFocusInWindow();
        }
    }

    class ProxyTestButton
    extends AbstractTestButton {
        ProxyTestButton() {
            super("Verify");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            InetProxyPanel.this.testConnection();
        }
    }
}

