/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.resutable;

import com.selima.fbi.core.IPAYEMessage;
import com.selima.fbi.ui.content.resutable.AbstractResultsTreeTableModel;
import com.selima.fbi.ui.content.resutable.BasicRow;
import com.selima.fbi.ui.content.resutable.ErrorMessageRow;
import com.selima.fbi.ui.content.resutable.ErrorResponseRow;
import com.selima.fbi.ui.content.resutable.Row;
import com.selima.fbi.ui.content.resutable.SuccessRow;
import java.util.List;

public class SendResultsTreeTableModel
extends AbstractResultsTreeTableModel<RootRow> {
    public SendResultsTreeTableModel() {
        super(new RootRow());
    }

    public void setMessages(List<IPAYEMessage> messages) {
        ((RootRow)this.rootRow).setMessages(messages);
        this.fireStructureChange();
    }

    static class SendErrorResponseRow
    extends ErrorResponseRow {
        SendErrorResponseRow(IPAYEMessage message) {
            super(message, message.getErrorResponse());
            this.addChild(new SubmissionDetailsInfoRow(message));
        }
    }

    static class SendErrorMessageRow
    extends ErrorMessageRow {
        SendErrorMessageRow(IPAYEMessage message) {
            super(message, message.getErrorMessage());
            this.addChild(new SubmissionDetailsInfoRow(message));
        }
    }

    static class SubmissionDetailsInfoRow
    extends Row {
        SubmissionDetailsInfoRow(IPAYEMessage message) {
            this.addChild(new BasicRow((Object)"Timestamp", (Object)message.getIssueDate()));
            this.addChild(new BasicRow((Object)"Correlation ID", (Object)message.getCorrelationId()));
        }

        @Override
        public Object getValueAt(int col) {
            return col == 0 ? "More Information" : "";
        }
    }

    static class SendSuccessRow
    extends SuccessRow {
        SendSuccessRow(IPAYEMessage message) {
            super(message, message.getSuccessResponse());
            this.addChild(new SubmissionDetailsInfoRow(message));
        }
    }

    static class RootRow
    extends Row {
        RootRow() {
        }

        void setMessages(List<IPAYEMessage> messages) {
            for (IPAYEMessage message : messages) {
                if (message.isSuccessful()) {
                    this.addChild(new SendSuccessRow(message));
                    continue;
                }
                if (message.isFailed()) {
                    this.addChild(new SendErrorResponseRow(message));
                    continue;
                }
                this.addChild(new SendErrorMessageRow(message));
            }
        }

        @Override
        public Object getValueAt(int col) {
            return "";
        }
    }
}

