/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.resutable;

import com.selima.fbi.ui.content.resutable.AbstractResultsTable;
import com.selima.fbi.ui.content.resutable.AbstractResultsTreeTableModel;
import com.selima.fbi.ui.content.resutable.HtmlTablesPrintable;
import com.selima.fbi.ui.content.resutable.Row;
import com.selima.fbi.ui.content.resutable.RowVisitor;
import com.selima.framework.util.Util;
import java.awt.print.Printable;
import java.text.MessageFormat;
import java.util.LinkedList;

public class PrintResultsTableVisitor
extends RowVisitor {
    private String title;
    private StringBuilder html;

    public PrintResultsTableVisitor(AbstractResultsTable table, String title) {
        super((Row)((AbstractResultsTreeTableModel)table.getTreeTableModel()).getRoot());
        this.title = title;
    }

    @Override
    public void visit() {
        this.html = new StringBuilder();
        super.visit();
    }

    @Override
    protected void visitBegin(Row row, LinkedList<Row> path) {
        int depth = path.size();
        if (depth == 0) {
            this.html.append("<html>").append("<body>");
            if (!Util.isEmpty((Object)this.title)) {
                this.html.append("<H1>" + this.title + "</H1>");
            }
        } else {
            String contentCellStyle = "";
            if (depth == 1) {
                this.html.append("<table width='100%' cellspacing='1' cellpadding='0'>");
                contentCellStyle = contentCellStyle + "margin-top:25px;padding-top:5px;padding-bottom:5px;";
            } else if (depth == 2) {
                this.html.append("<tr><td colspan='2'>");
                this.html.append("<table width='100%' cellspacing='1' cellpadding='0'>");
                if (!row.isLeaf()) {
                    contentCellStyle = contentCellStyle + "margin-top:5px;padding-top:2px;padding-bottom:3px;";
                }
            }
            if (row.isLeaf()) {
                contentCellStyle = contentCellStyle + "font-size:8pt;";
            } else {
                String fragment = Integer.toHexString(Math.min(200 + 16 * path.size(), 255));
                String color = "#" + fragment + fragment + fragment;
                String fontSize = String.valueOf(Math.max(8, 12 - 2 * path.size()));
                contentCellStyle = contentCellStyle + "background-color:" + color + ";font-size:" + fontSize + "pt;font-weight:bold;";
            }
            this.html.append("<tr>").append("<td width='15%' valign='top' style='").append(contentCellStyle).append("'>").append(row.getValueAt(0)).append("</td>").append("<td width='85%' style='").append(contentCellStyle).append("'>").append(row.getValueAt(1)).append("</td>").append("</tr>");
        }
    }

    @Override
    protected void visitEnd(Row row, LinkedList<Row> path) {
        switch (path.size()) {
            case 0: {
                this.html.append("</body>");
                this.html.append("</html>");
                break;
            }
            case 1: {
                this.html.append("</table>");
                break;
            }
            case 2: {
                this.html.append("</table></td></tr>");
            }
        }
    }

    public String generateHtml() {
        this.visit();
        return this.html.toString();
    }

    public Printable generatePrintable() {
        return HtmlTablesPrintable.getPrintable(this.generateHtml(), null, new MessageFormat("Page {0}"));
    }
}

