/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.resutable;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javax.swing.BorderFactory;
import javax.swing.CellRendererPane;
import javax.swing.JEditorPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.text.View;

public class HtmlTablesPrintable
implements Printable {
    private final MessageFormat headerFormat;
    private final MessageFormat footerFormat;
    private final JEditorPane printPane;
    private boolean isLayouted;
    private final List<VerticalSegment> rowMetrics;
    private final List<VerticalSegment> pageMetrics;

    public static Printable getPrintable(String html, MessageFormat headerFormat, MessageFormat footerFormat) {
        return new HtmlTablesPrintable(html, headerFormat, footerFormat);
    }

    private HtmlTablesPrintable(String html, MessageFormat headerFormat, MessageFormat footerFormat) {
        this.headerFormat = headerFormat;
        this.footerFormat = footerFormat;
        this.pageMetrics = Collections.synchronizedList(new ArrayList());
        this.rowMetrics = new ArrayList<VerticalSegment>();
        this.printPane = new JEditorPane();
        this.printPane.setContentType("text/html");
        this.printPane.setText(html);
        this.printPane.setBorder(null);
        this.isLayouted = false;
    }

    @Override
    public int print(final Graphics graphics, final PageFormat pf, final int pageIndex) throws PrinterException {
        int result;
        if (!this.isLayouted) {
            this.layout((int)Math.floor(pf.getImageableWidth()));
            this.calculateRowMetrics();
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            Callable<Integer> printOnEDT = new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return HtmlTablesPrintable.this.printOnEDT(graphics, pf, pageIndex);
                }
            };
            FutureTask<Integer> futurePrintOnEDT = new FutureTask<Integer>(printOnEDT);
            SwingUtilities.invokeLater(futurePrintOnEDT);
            try {
                result = futurePrintOnEDT.get();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof PrinterException) {
                    throw (PrinterException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw new RuntimeException(cause);
            }
        } else {
            result = this.printOnEDT(graphics, pf, pageIndex);
        }
        return result;
    }

    private int printOnEDT(Graphics graphics, PageFormat pf, int pageIndex) throws PrinterException {
        assert (SwingUtilities.isEventDispatchThread());
        Border border = BorderFactory.createEmptyBorder();
        Object[] formatArg = new Object[]{pageIndex + 1};
        if (this.headerFormat != null) {
            border = new TitledBorder(border, this.headerFormat.format(formatArg), 2, 1, this.printPane.getFont().deriveFont(1, 18.0f), this.printPane.getForeground());
        }
        if (this.footerFormat != null) {
            border = new TitledBorder(border, this.footerFormat.format(formatArg), 2, 6, this.printPane.getFont().deriveFont(0, 12.0f), this.printPane.getForeground());
        }
        Insets borderInsets = border.getBorderInsets(this.printPane);
        int imageableWidth = (int)Math.floor(pf.getImageableWidth());
        int imageableHeihgt = (int)Math.floor(pf.getImageableHeight());
        int pageHeight = imageableHeihgt - borderInsets.top - borderInsets.bottom;
        this.updatePageMetrics(pageIndex, pageHeight);
        if (this.pageMetrics.size() <= pageIndex) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.translate(pf.getImageableX(), pf.getImageableY());
        border.paintBorder(this.printPane, graphics2D, 0, 0, imageableWidth, imageableHeihgt);
        graphics2D.translate(0, borderInsets.top);
        int pageContentHeight = this.pageMetrics.get((int)pageIndex).end - this.pageMetrics.get((int)pageIndex).start + 1;
        Rectangle clip = new Rectangle(0, 0, (int)pf.getWidth(), pageContentHeight);
        graphics2D.clip(clip);
        graphics2D.translate(0, -this.pageMetrics.get((int)pageIndex).start);
        this.printPane.print(graphics2D);
        return 0;
    }

    private void layout(final int width) {
        if (!SwingUtilities.isEventDispatchThread()) {
            Callable<Object> layoutOnEDT = new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    HtmlTablesPrintable.this.layoutOnEDT(width);
                    return null;
                }
            };
            FutureTask<Object> futureLayoutOnEDT = new FutureTask<Object>(layoutOnEDT);
            SwingUtilities.invokeLater(futureLayoutOnEDT);
            try {
                futureLayoutOnEDT.get();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw new RuntimeException(cause);
            }
        } else {
            this.layoutOnEDT(width);
        }
        this.isLayouted = true;
    }

    private void layoutOnEDT(int width) {
        assert (SwingUtilities.isEventDispatchThread());
        JViewport viewport = new JViewport();
        viewport.setBorder(null);
        Dimension size = new Dimension(width, 2147482647);
        this.printPane.setSize(size);
        viewport.setSize(size);
        viewport.add(this.printPane);
        CellRendererPane rendererPane = new CellRendererPane();
        rendererPane.add(viewport);
    }

    private void updatePageMetrics(int pageIndex, int pageHeight) {
        while (pageIndex >= this.pageMetrics.size() && !this.rowMetrics.isEmpty()) {
            int afterLastRow;
            int lastPage = this.pageMetrics.size() - 1;
            int pageStart = lastPage >= 0 ? this.pageMetrics.get((int)lastPage).end + 1 : 0;
            int afterLastTable = 0;
            for (afterLastRow = 0; afterLastRow < this.rowMetrics.size(); ++afterLastRow) {
                VerticalSegment segment = this.rowMetrics.get(afterLastRow);
                if (segment.startOfBlock) {
                    afterLastTable = afterLastRow;
                }
                if (segment.end - pageStart >= pageHeight) break;
            }
            if (afterLastRow < this.rowMetrics.size() && afterLastTable > 0) {
                afterLastRow = afterLastTable;
            }
            if (afterLastRow == 0) {
                this.pageMetrics.add(new VerticalSegment(pageStart, pageStart + pageHeight - 1));
                continue;
            }
            this.pageMetrics.add(new VerticalSegment(pageStart, this.rowMetrics.get((int)(afterLastRow - 1)).end));
            for (int i = 0; i < afterLastRow; ++i) {
                this.rowMetrics.remove(0);
            }
        }
    }

    private void calculateRowMetrics() {
        View rootView = this.printPane.getUI().getRootView(this.printPane);
        this.gatherTableRows(rootView, this.printPane.getBounds(), this.rowMetrics);
    }

    private void gatherTableRows(View view, Shape viewBounds, List<VerticalSegment> results) {
        view.setSize(viewBounds.getBounds().width, viewBounds.getBounds().height);
        for (int i = 0; i < view.getViewCount(); ++i) {
            View child = view.getView(i);
            Shape childBounds = view.getChildAllocation(i, viewBounds);
            if ("RowView".equals(child.getClass().getSimpleName())) {
                Rectangle bounds = childBounds.getBounds();
                results.add(new VerticalSegment(bounds.y, bounds.y + bounds.height - 1, i == 0));
                continue;
            }
            this.gatherTableRows(child, childBounds, results);
        }
    }

    List<VerticalSegment> getRowMetrics() {
        return Collections.unmodifiableList(this.rowMetrics);
    }

    List<VerticalSegment> getPageMetrics() {
        return Collections.unmodifiableList(this.pageMetrics);
    }

    static class VerticalSegment {
        final int start;
        final int end;
        final boolean startOfBlock;

        VerticalSegment(int start, int end) {
            this(start, end, false);
        }

        VerticalSegment(int start, int end, boolean startOfBlock) {
            this.start = start;
            this.end = end;
            this.startOfBlock = startOfBlock;
        }

        public String toString() {
            return "VerticalSegment(" + this.start + "," + this.end + "," + this.startOfBlock + ")";
        }
    }
}

