/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.resutable;

import com.selima.fbi.ui.content.resutable.AbstractResultsTable;
import com.selima.fbi.ui.content.resutable.AbstractResultsTreeTableModel;
import com.selima.fbi.ui.content.resutable.Row;
import com.selima.fbi.ui.content.resutable.RowVisitor;
import java.util.LinkedList;
import javax.swing.table.TableColumnModel;

public class CsvResultsTableVisitor
extends RowVisitor {
    private StringBuilder csv;
    private AbstractResultsTable table;

    public CsvResultsTableVisitor(AbstractResultsTable table) {
        super((Row)((AbstractResultsTreeTableModel)table.getTreeTableModel()).getRoot());
        this.table = table;
    }

    @Override
    public void visit() {
        this.csv = new StringBuilder();
        super.visit();
    }

    @Override
    protected void visitBegin(Row row, LinkedList<Row> path) {
        if (path.size() > 0) {
            this.formatRow(row, this.csv);
        }
    }

    private void formatRow(Row row, StringBuilder sb) {
        sb.append(this.formatCell(row.getValueAt(0)));
        sb.append(",");
        sb.append(this.formatCell(row.getValueAt(1)));
        sb.append("\n");
    }

    private String formatCell(Object o) {
        if (o == null) {
            return "";
        }
        String s = o.toString();
        if (s == null) {
            return "";
        }
        if ((s = s.replaceAll("\"", "\"\"")).contains("\"") || s.contains(",") || s.contains("\n")) {
            s = "\"" + s + "\"";
        }
        return s;
    }

    public String generateCsvForAll() {
        this.visit();
        return this.csv.toString();
    }

    public String generateCsvForSelected() {
        StringBuilder csv = new StringBuilder();
        for (int selectedRow : this.table.getSelectedRows()) {
            LinkedList<Row> path = this.table.pathAt(selectedRow);
            Row row = path.getLast();
            TableColumnModel columnModel = this.table.getColumnModel();
            for (int selectedColumn : this.table.getSelectedColumns()) {
                int index = columnModel.getColumn(selectedColumn).getModelIndex();
                csv.append(this.formatCell(row.getValueAt(index))).append(",");
            }
            csv.setCharAt(csv.length() - 1, '\n');
        }
        return csv.toString();
    }
}

