/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.result;

import com.selima.fbi.CancelException;
import com.selima.fbi.core.IPAYEMessage;
import com.selima.fbi.submission.SubmitException;
import com.selima.fbi.ui.ClientContent;
import com.selima.fbi.ui.MailServiceClientContext;
import com.selima.fbi.ui.common.waitdlg.BasicInterrupter;
import com.selima.fbi.ui.common.waitdlg.MultiCompletingModel;
import com.selima.fbi.ui.common.waitdlg.SingletonWaitingDialog;
import com.selima.fbi.ui.content.IncompleteContent;
import com.selima.fbi.ui.content.result.AbstractSubmissionResultsContent;
import com.selima.fbi.ui.content.resutable.SendResultsTreeTable;
import com.selima.fbi.ui.edialog.FailureDialog;
import com.selima.framework.exception.BackendException;
import com.selima.framework.threading.BackendOperationHandle;
import com.selima.framework.threading.BackendWork;
import com.selima.framework.threading.CanceledException;
import com.selima.framework.threading.SwingOperationHandle;
import com.selima.framework.util.logging.LogAPI;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public class CompletionContent
extends AbstractSubmissionResultsContent<SendResultsTreeTable> {
    private SendResultsTreeTable table;
    private List<IPAYEMessage> messages;
    private boolean executed;
    private int actual;

    public CompletionContent(MailServiceClientContext cctx, IncompleteContent parent, List<IPAYEMessage> messages) {
        this(cctx, parent, messages, new SendResultsTreeTable());
    }

    private CompletionContent(MailServiceClientContext cctx, ClientContent parent, List<IPAYEMessage> messages, SendResultsTreeTable table) {
        super(cctx, parent, table);
        this.messages = messages;
        this.table = table;
    }

    @Override
    public BackendWork getOpeningWork() {
        if (this.executed) {
            return super.getOpeningWork();
        }
        this.executed = true;
        return new CompletingWork();
    }

    @Override
    public String getContentName() {
        return "Completion Results";
    }

    @Override
    public String getDescription() {
        return "Completing Messages";
    }

    @Override
    public String getHelpTopic() {
        return "content.context-help.complete-result";
    }

    class CompletingWork
    extends BasicInterrupter
    implements BackendWork {
        private IPAYEMessage message;

        CompletingWork() {
            SingletonWaitingDialog.showDialog(CompletionContent.this.getClientContext(), new MultiCompletingModel(CompletionContent.this.messages.size()){
                int oldIndex;

                @Override
                public int actualIndex() {
                    if (this.oldIndex != CompletionContent.this.actual) {
                        this.stepDuration = 0;
                        this.pollCount = 1;
                    }
                    this.oldIndex = CompletionContent.this.actual;
                    return CompletionContent.this.actual + 1;
                }

                @Override
                public String actualTitle() {
                    String result = CompletingWork.this.message.getSubject();
                    if (result.length() > 30) {
                        result = result.substring(0, 27) + "...";
                    }
                    return result;
                }
            }, this);
        }

        public String getName() {
            return "Completing messages";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invokeBackend(BackendOperationHandle handle) throws BackendException {
            try {
                ArrayList<IPAYEMessage> completedMessages = new ArrayList<IPAYEMessage>(CompletionContent.this.messages.size());
                CompletionContent.this.actual = 0;
                while (CompletionContent.this.actual < CompletionContent.this.messages.size()) {
                    this.message = (IPAYEMessage)CompletionContent.this.messages.get(CompletionContent.this.actual);
                    try {
                        handle.checkCancelRequest();
                        this.message.complete();
                    }
                    catch (CanceledException e) {
                        break;
                    }
                    catch (CancelException e) {
                        break;
                    }
                    catch (SubmitException submitException) {
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    completedMessages.add(this.message);
                    CompletionContent.this.actual++;
                }
                handle.setResult(completedMessages);
            }
            finally {
                this.message = null;
                SingletonWaitingDialog.hideDialog();
            }
        }

        public void invokeSwing(SwingOperationHandle handle) {
            if (handle.getResult() != null) {
                List result = (List)handle.getResult();
                if (result.size() == 0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CompletionContent.this.getClientContext().displayContent(CompletionContent.this.parent);
                        }
                    });
                }
                ((IncompleteContent)CompletionContent.this.parent).hideRows(result);
                CompletionContent.this.table.setMessages(result);
            } else {
                FailureDialog.show(CompletionContent.this.getClientContext().getTitle(), "<b>Failed to complete messages</b>", handle.getFailure());
                LogAPI.logSevere((Throwable)handle.getFailure());
            }
        }
    }
}

