/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.result;

import com.selima.fbi.ui.ClientContent;
import com.selima.fbi.ui.MailServiceClientContext;
import com.selima.fbi.ui.common.SwingHelper;
import com.selima.fbi.ui.common.ToolBar;
import com.selima.fbi.ui.content.AbstractClientContent;
import com.selima.fbi.ui.content.PrintAction;
import com.selima.fbi.ui.content.resutable.AbstractResultsTable;
import com.selima.fbi.ui.content.resutable.CsvResultsTableVisitor;
import com.selima.fbi.ui.content.resutable.PrintResultsTableVisitor;
import com.selima.framework.threading.BackendOperationHandle;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.print.Printable;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JScrollPane;
import sun.swing.PrintingStatus;

public abstract class AbstractResultsContent<TableType extends AbstractResultsTable>
extends AbstractClientContent {
    protected ClientContent parent;
    protected ToolBar toolBar;
    protected TableType table;

    public AbstractResultsContent(MailServiceClientContext cctx, ClientContent parent, TableType table) {
        this("/img/32x32/mimetypes/pen.png", cctx, parent, table);
    }

    public AbstractResultsContent(String iconPath, MailServiceClientContext cctx, ClientContent parent, TableType table) {
        super(cctx, iconPath, null);
        this.table = table;
        this.parent = parent;
        this.toolBar = new ToolBar(new ResultsPrintAction(), new CopySelectedAction(), new CopyAllAction(), Box.createGlue(), new CloseAction());
        this.add((Component)new JScrollPane((Component)table), "Center");
        ((AbstractResultsTable)table).setToolBar(this.toolBar);
    }

    @Override
    public ToolBar getToolBar() {
        return this.toolBar;
    }

    class CopyAllAction
    extends AbstractAction {
        CopyAllAction() {
            super("Copy All", SwingHelper.imageIcon("/img/16x16/actions/editcopyall.png"));
        }

        @Override
        public void actionPerformed(ActionEvent actionevent) {
            String csv = new CsvResultsTableVisitor((AbstractResultsTable)AbstractResultsContent.this.table).generateCsvForAll();
            StringSelection transferable = new StringSelection(csv);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(transferable, null);
        }
    }

    class CopySelectedAction
    extends AbstractAction {
        CopySelectedAction() {
            super("Copy Selected", SwingHelper.imageIcon("/img/16x16/actions/editcopy.png"));
        }

        @Override
        public void actionPerformed(ActionEvent actionevent) {
            String csv = new CsvResultsTableVisitor((AbstractResultsTable)AbstractResultsContent.this.table).generateCsvForSelected();
            StringSelection transferable = new StringSelection(csv);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(transferable, null);
        }
    }

    class ResultsPrintAction
    extends PrintAction {
        ResultsPrintAction() {
            super(AbstractResultsContent.this.getClientContext());
        }

        @Override
        protected String getPrintName() {
            return AbstractResultsContent.this.getContentName();
        }

        @Override
        protected Printable createPrintable(PrintingStatus printingStatus, BackendOperationHandle handle) {
            return new PrintResultsTableVisitor((AbstractResultsTable)AbstractResultsContent.this.table, AbstractResultsContent.this.getDescription()).generatePrintable();
        }
    }

    class CloseAction
    extends AbstractAction {
        CloseAction() {
            super("Close", SwingHelper.imageIcon("/img/16x16/actions/button_cancel.png"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            AbstractResultsContent.this.getClientContext().displayContent(AbstractResultsContent.this.parent);
        }
    }
}

