/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.mboxtable;

import com.selima.fbi.core.IDPSMessage;
import com.selima.fbi.core.IPayrollCheckedMessage;
import com.selima.fbi.ui.ClientContext;
import com.selima.fbi.ui.common.SwingHelper;
import com.selima.fbi.ui.content.mboxtable.DPSMessageTable;
import com.selima.fbi.ui.content.mboxtable.PayrollCheckedTableModel;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class PayrollCheckedMessageTable
extends DPSMessageTable {
    public PayrollCheckedMessageTable(ClientContext cctx) {
        super(cctx, new PayrollCheckedTableModel());
        this.setDefaultRenderer(Object.class, new PayrollCheckRenderer(this.getDefaultRenderer(Object.class)));
    }

    private static class PayrollCheckRenderer
    implements TableCellRenderer {
        static final Color STALE_FOREGROUND = new Color(156, 143, 99);
        static final Icon CHECKED_OK_ICON = SwingHelper.imageIcon("/img/16x16/apps/mail_ok.png");
        static final Icon CHECKED_NOT_OK_ICON = SwingHelper.imageIcon("/img/16x16/apps/mail_error.png");
        private TableCellRenderer wrapped;

        private PayrollCheckRenderer(TableCellRenderer renderer) {
            this.wrapped = renderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)this.wrapped.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            IDPSMessage message = (IDPSMessage)((DPSMessageTable)table).getModel().getRow(row).getRowData();
            if (message instanceof IPayrollCheckedMessage) {
                IPayrollCheckedMessage payrollCheckedMessage = (IPayrollCheckedMessage)message;
                if (!payrollCheckedMessage.isUptodate()) {
                    label.setForeground(STALE_FOREGROUND);
                } else if (column == 0) {
                    label.setIcon(payrollCheckedMessage.getPayrollWarningMessage() == null ? CHECKED_OK_ICON : CHECKED_NOT_OK_ICON);
                }
            }
            return label;
        }
    }
}

