/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.mboxtable;

import com.selima.fbi.core.IMailMessage;
import com.selima.fbi.ui.common.table.RowTableModel;
import com.selima.fbi.ui.common.table.RowTableModelColumn;
import com.selima.fbi.ui.common.table.RowTableModelGetter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

public abstract class MailMessageTableModel<MessageType extends IMailMessage>
extends RowTableModel<MessageType> {
    private volatile List<MessageType> messages = Collections.emptyList();
    private int idIndex;
    private boolean loaded;

    protected MailMessageTableModel(RowTableModelColumn<? super MessageType> ... columns) {
        super(columns);
        int typeIndex = -1;
        int empRefIndex = -1;
        for (int i = columns.length - 1; i >= 0; --i) {
            if (columns[i] instanceof IdColumn) {
                this.idIndex = i;
            }
            if (columns[i] instanceof TypeColumn) {
                typeIndex = i;
            }
            if (!(columns[i] instanceof EmprefColumn)) continue;
            empRefIndex = i;
        }
        this.sort(this.idIndex);
        this.sort(typeIndex);
        this.sort(empRefIndex);
    }

    @Override
    protected void setColumns(RowTableModelColumn<MessageType>[] columns) {
        super.setColumns(columns);
        for (int i = columns.length - 1; i >= 0; --i) {
            if (!(columns[i] instanceof IdColumn)) continue;
            this.idIndex = i;
            break;
        }
    }

    public List<MessageType> getMessages() {
        if (this.messages == null) {
            this.messages = new ArrayList<MessageType>(this.getRowCount());
            for (int i = 0; i < this.getRowCount(); ++i) {
                this.messages.add(this.getRow(i).getRowData());
            }
        }
        return this.messages;
    }

    public void setMessages(List<MessageType> messages) {
        this.loaded = true;
        this.messages = messages;
        int cnt = messages.size();
        RowTableModel.TableRow[] rows = new RowTableModel.TableRow[cnt];
        ListIterator<MessageType> it = messages.listIterator();
        while (it.hasNext()) {
            rows[it.nextIndex()] = new MessageRow(this, it.nextIndex(), (IMailMessage)it.next());
        }
        super.setRows(rows);
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void hideRows(String ... ids) {
        this.messages = null;
        super.hideRows(ids, this.getColumns()[this.idIndex]);
    }

    @Override
    public void hideRows(List<MessageType> hiddenRows) {
        this.messages = null;
        super.hideRows(hiddenRows);
    }

    @Override
    public void hideRows(String[] values, RowTableModelColumn<? super MessageType> column) {
        this.messages = null;
        super.hideRows(values, column);
    }

    @Override
    public void hideRowsWithValues(Object rowValue) {
        this.messages = null;
        super.hideRowsWithValues(rowValue);
    }

    @Override
    public void invokeSorting() {
        super.invokeSorting();
    }

    @Override
    public void fireTableDataChanged() {
        this.messages = null;
        super.fireTableDataChanged();
    }

    @Override
    public RowTableModel.TableRow<MessageType> getRow(int index) {
        return super.getRow(index);
    }

    static class EmprefColumn
    extends RowTableModelColumn<IMailMessage> {
        EmprefColumn() {
            this(120);
        }

        EmprefColumn(int size) {
            super("Employer", size, 2, new EmployerGetter());
        }
    }

    static class SubjectColumn
    extends RowTableModelColumn<IMailMessage> {
        SubjectColumn() {
            this(290);
        }

        SubjectColumn(int size) {
            super("Subject", size, 2, new SubjectGetter());
        }
    }

    static class TypeColumn
    extends RowTableModelColumn<IMailMessage> {
        TypeColumn() {
            this(85);
        }

        TypeColumn(int size) {
            super("Type", size, 2, new FormTypeGetter());
        }
    }

    static class DateColumn
    extends RowTableModelColumn<IMailMessage> {
        DateColumn() {
            this(100);
        }

        DateColumn(int size) {
            super("Date", size, 2, new DateGetter());
        }
    }

    static abstract class IdColumn<T extends IMailMessage>
    extends RowTableModelColumn<T> {
        IdColumn() {
            this(90);
        }

        IdColumn(int size) {
            super("Id", size, 2, null);
            this.getter = this.createGetter();
        }

        protected abstract RowTableModelGetter<T> createGetter();
    }

    private static class FormTypeGetter
    implements RowTableModelGetter<IMailMessage> {
        private FormTypeGetter() {
        }

        @Override
        public Comparable<?> getValue(IMailMessage message) {
            return message.getFormType();
        }
    }

    private static class EmployerGetter
    implements RowTableModelGetter<IMailMessage> {
        private EmployerGetter() {
        }

        @Override
        public Comparable<?> getValue(IMailMessage message) {
            return message.getEmpRef();
        }
    }

    private static class DateGetter
    implements RowTableModelGetter<IMailMessage> {
        private DateGetter() {
        }

        @Override
        public Comparable<?> getValue(IMailMessage message) {
            return message.getIssueDate();
        }
    }

    private static class SubjectGetter
    implements RowTableModelGetter<IMailMessage> {
        private SubjectGetter() {
        }

        @Override
        public Comparable<?> getValue(IMailMessage message) {
            return message.getSubject();
        }
    }

    public static class MessageRow
    extends RowTableModel.TableRow<MessageType> {
        MessageType message;
        final /* synthetic */ MailMessageTableModel this$0;

        MessageRow(int rowIndex, MessageType message) {
            this.this$0 = this$0;
            super(rowIndex);
            this.message = message;
        }

        @Override
        public MessageType getRowData() {
            return this.message;
        }

        public String toString() {
            return this.message.getSubject();
        }
    }
}

