/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.mboxtable;

import com.selima.fbi.core.IMailMessage;
import com.selima.fbi.ui.ClientContext;
import com.selima.fbi.ui.common.SwingHelper;
import com.selima.fbi.ui.common.table.Column;
import com.selima.fbi.ui.common.table.ContentTable;
import com.selima.fbi.ui.content.mboxtable.MailMessageTableModel;
import java.awt.Color;
import java.awt.Component;
import java.text.DateFormat;
import java.text.Format;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class MailMessageTable<T extends IMailMessage>
extends ContentTable {
    public MailMessageTable(ClientContext cctx, MailMessageTableModel<T> model) {
        super(cctx, model);
        this.setDefaultRenderer(Object.class, new CellRenderer(this.getDefaultRenderer(Object.class)));
    }

    @Override
    public MailMessageTableModel<T> getModel() {
        return (MailMessageTableModel)super.getModel();
    }

    public void setMessages(List<T> messages) {
        ((MailMessageTableModel)this.getModel()).setMessages(messages);
        this.invokeSorting();
    }

    protected static class CellRenderer
    implements TableCellRenderer {
        private static final Icon MAIL_ICON = SwingHelper.imageIcon("/img/16x16/actions/mail_generic_open4.png");
        private Format format = DateFormat.getDateInstance(3);
        private TableCellRenderer wrapped;

        private CellRenderer(TableCellRenderer renderer) {
            this.wrapped = renderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof Date) {
                value = this.format.format(value);
            }
            JLabel label = (JLabel)this.wrapped.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Column columnInfo = (Column)table.getColumnModel().getColumn(column).getIdentifier();
            label.setHorizontalAlignment(columnInfo.getAlign());
            label.setBorder(BorderFactory.createCompoundBorder(label.getBorder(), BorderFactory.createEmptyBorder(2, 10, 2, 10)));
            label.setForeground(Color.BLACK);
            if (!label.getFont().isPlain()) {
                label.setFont(label.getFont().deriveFont(0));
            }
            if (column == 0) {
                label.setIcon(MAIL_ICON);
            } else {
                label.setIcon(null);
            }
            return label;
        }
    }
}

