/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.mboxtable;

import com.selima.fbi.core.IDPSMessage;
import com.selima.fbi.ui.ClientContext;
import com.selima.fbi.ui.common.SwingHelper;
import com.selima.fbi.ui.content.mboxtable.DPSMessageTableModel;
import com.selima.fbi.ui.content.mboxtable.MailMessageTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellRenderer;

public abstract class DPSMessageTable
extends MailMessageTable<IDPSMessage> {
    public DPSMessageTable(ClientContext cctx) {
        this(cctx, new DPSMessageTableModel());
    }

    protected DPSMessageTable(ClientContext cctx, DPSMessageTableModel model) {
        super(cctx, model);
        this.setDefaultRenderer(Object.class, new DPSRenderer(this.getDefaultRenderer(Object.class)));
    }

    @Override
    public void createDefaultColumnsFromModel() {
        super.createDefaultColumnsFromModel();
        this.setPreferredScrollableViewportSize(this.getPreferredSize());
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        if (this.getParent() instanceof JViewport) {
            return this.getPreferredScrollableViewportSize().width <= this.getParent().getWidth();
        }
        return true;
    }

    @Override
    public DPSMessageTableModel getModel() {
        return (DPSMessageTableModel)super.getModel();
    }

    @Override
    public void tableChanged(TableModelEvent evt) {
        if (evt.getFirstRow() == -1) {
            ListSelectionModel rowSelection = this.getSelectionModel();
            int[] selectedRows = this.getSelectedRows();
            int anchorRow = rowSelection.getAnchorSelectionIndex();
            int leadRow = rowSelection.getLeadSelectionIndex();
            ListSelectionModel colSelection = this.getColumnModel().getSelectionModel();
            int[] selectedColumns = this.getSelectedColumns();
            int anchorCol = colSelection.getAnchorSelectionIndex();
            int leadCol = colSelection.getLeadSelectionIndex();
            Object leadIdentifier = leadCol >= 0 && leadCol < this.getColumnCount() ? this.getColumnModel().getColumn(leadCol).getIdentifier() : null;
            Object anchorIdentifier = anchorCol >= 0 && anchorCol < this.getColumnCount() ? this.getColumnModel().getColumn(anchorCol).getIdentifier() : null;
            super.tableChanged(evt);
            this.selectIndexes(rowSelection, selectedRows);
            rowSelection.setAnchorSelectionIndex(anchorRow);
            rowSelection.setLeadSelectionIndex(leadRow);
            colSelection = this.getColumnModel().getSelectionModel();
            this.selectIndexes(colSelection, selectedColumns);
            colSelection.setAnchorSelectionIndex(this.getColumnIndex(anchorIdentifier, anchorCol));
            colSelection.setLeadSelectionIndex(this.getColumnIndex(leadIdentifier, leadCol));
        } else {
            super.tableChanged(evt);
        }
    }

    private int getColumnIndex(Object identifier, int column) {
        block3: {
            try {
                column = this.getColumnModel().getColumnIndex(identifier);
            }
            catch (IllegalArgumentException e) {
                if (column < 0) {
                    column = 0;
                }
                if (column < this.getColumnCount()) break block3;
                column = this.getColumnCount() - 1;
            }
        }
        return column;
    }

    private void selectIndexes(ListSelectionModel model, int[] indexes) {
        int lastRow = 0;
        while (lastRow < indexes.length) {
            int firstRow = lastRow;
            int nextRow = indexes[lastRow] + 1;
            ++lastRow;
            while (lastRow < indexes.length && indexes[lastRow] == nextRow) {
                ++lastRow;
                ++nextRow;
            }
            model.addSelectionInterval(indexes[firstRow], indexes[lastRow - 1]);
        }
    }

    private static class DPSRenderer
    implements TableCellRenderer {
        static final Icon MAIL_NEW_ICON = SwingHelper.imageIcon("/img/16x16/actions/mail_generic.png");
        Font boldFont;
        private TableCellRenderer wrapped;

        private DPSRenderer(TableCellRenderer renderer) {
            this.wrapped = renderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)this.wrapped.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            IDPSMessage message = (IDPSMessage)((DPSMessageTable)table).getModel().getRow(row).getRowData();
            if (!message.isRead()) {
                if (column == 0) {
                    label.setIcon(MAIL_NEW_ICON);
                }
                if (!label.getFont().isBold()) {
                    if (this.boldFont == null) {
                        this.boldFont = label.getFont().deriveFont(1);
                    }
                    label.setFont(this.boldFont);
                }
            }
            if (!message.isTransferrable()) {
                label.setForeground(Color.GRAY);
            }
            label.setToolTipText(label.getText());
            return label;
        }
    }
}

