/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.html;

import com.selima.fbi.ui.content.html.HtmlPane;
import com.selima.fbi.ui.content.html.PrintingDetails;
import com.selima.fbi.ui.content.html.PrintingUserAgentContext;
import com.selima.fbi.ui.content.html.SinglePagePortrait;
import com.selima.fbi.ui.content.html.TwoPageLandscape;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.renderer.RBlock;
import org.lobobrowser.html.renderer.RBlockViewport;

public class PrintHtmlPane
extends HtmlPane
implements Printable {
    final PrintingDetails printingDetails;

    public PrintHtmlPane(PrintingDetails printingDetails) {
        super(new Insets(0, 0, 0, 0), (UserAgentContext)new PrintingUserAgentContext());
        this.printingDetails = printingDetails;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex >= this.printingDetails.getNumOfPages()) {
            return 1;
        }
        Graphics2D graphics2d = (Graphics2D)graphics;
        RBlock rblock = (RBlock)this.getBlockRenderable();
        RBlockViewport blockViewport = rblock.getRBlockViewport();
        if (this.printingDetails instanceof SinglePagePortrait) {
            AffineTransform transform = new AffineTransform();
            transform.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            double widthScalingRatio = pageFormat.getImageableWidth() / (double)blockViewport.getWidth();
            double heightScalingRatio = pageFormat.getImageableHeight() / (double)blockViewport.getHeight();
            double minimumScaling = Math.min(widthScalingRatio, heightScalingRatio);
            transform.scale(minimumScaling, minimumScaling);
            graphics2d.transform(transform);
        } else if (this.printingDetails instanceof TwoPageLandscape) {
            TwoPageLandscape twoPageDetails = (TwoPageLandscape)this.printingDetails;
            AffineTransform transform = new AffineTransform();
            transform.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            double widthScalingRation = pageFormat.getImageableWidth() / (double)blockViewport.getWidth();
            double firstPageHeightScalingRatio = pageFormat.getImageableHeight() / (double)twoPageDetails.getDivider();
            double secondPageHeightScalingRation = pageFormat.getImageableHeight() / (double)(blockViewport.getHeight() - twoPageDetails.getDivider());
            double minimumScaling = Math.min(widthScalingRation, Math.min(firstPageHeightScalingRatio, secondPageHeightScalingRation));
            transform.scale(minimumScaling, minimumScaling);
            if (pageIndex == 1) {
                transform.translate(0.0, -twoPageDetails.getDivider());
            }
            graphics2d.transform(transform);
            if (pageIndex == 0 && firstPageHeightScalingRatio > minimumScaling) {
                graphics2d.setClip(0, 0, blockViewport.getWidth(), twoPageDetails.getDivider());
            }
        } else {
            throw new IllegalStateException("Unsupported printing mode [" + this.printingDetails + "]");
        }
        RepaintManager currentManager = RepaintManager.currentManager((JComponent)((Object)this));
        currentManager.setDoubleBufferingEnabled(false);
        try {
            blockViewport.paint(graphics);
        }
        finally {
            currentManager.setDoubleBufferingEnabled(true);
        }
        return 0;
    }
}

