/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.html;

import com.selima.fbi.ui.common.PopupOwner;
import com.selima.fbi.ui.content.html.CustomHTMLDocumentImpl;
import com.selima.fbi.ui.content.html.CustomHtmlRendererContext;
import com.selima.framework.threading.EventBroadcast;
import com.selima.framework.threading.EventBroadcastFactory;
import com.selima.framework.threading.ISubmitter;
import com.selima.framework.util.logging.LogAPI;
import java.awt.Color;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.NodeImpl;
import org.lobobrowser.html.domimpl.TextImpl;
import org.lobobrowser.html.domimpl.UINode;
import org.lobobrowser.html.gui.HtmlBlockPanel;
import org.lobobrowser.html.gui.HtmlPanel;
import org.lobobrowser.html.parser.InputSourceImpl;
import org.lobobrowser.html.renderer.BoundableRenderable;
import org.lobobrowser.html.renderer.FrameContext;
import org.lobobrowser.html.renderer.RBlock;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.test.SimpleUserAgentContext;
import org.w3c.dom.Document;
import org.w3c.dom.html2.HTMLDocument;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class HtmlPane
extends HtmlPanel {
    EventBroadcast<PopupOwner> popupListeners = EventBroadcastFactory.createEventBroadcast(PopupOwner.class);
    Stack<HTMLDocument> history = new Stack();
    CustomHtmlRendererContext rendererContext;
    PropertyChangeListener loadedForwarder;
    Insets htmlComponentPaddingInsets;
    Point scrollingOffset = new Point();
    String status;

    public HtmlPane(Insets insets) {
        this(insets, (UserAgentContext)new SimpleUserAgentContext());
    }

    public HtmlPane(Insets insets, UserAgentContext userAgentContext) {
        this.rendererContext = new CustomHtmlRendererContext(this, userAgentContext);
        this.htmlComponentPaddingInsets = insets;
    }

    public void setSubmitter(ISubmitter submitter) {
        this.rendererContext.setSubmitter(submitter);
    }

    public void highlight(String string) {
        if (this.htmlBlockPanel == null) {
            return;
        }
        BoundableRenderable root = this.htmlBlockPanel.getRootRenderable();
        List parts = string != null ? Arrays.asList(string.split("\\s")) : Collections.emptyList();
        for (TextImpl text : this.textsOf((NodeImpl)this.getHtmlDocument())) {
            text.setHiglightedWords(parts);
        }
    }

    Iterable<TextImpl> textsOf(NodeImpl node) {
        LinkedList<TextImpl> texts = new LinkedList<TextImpl>();
        this.gatherTexts(node, texts);
        return texts;
    }

    void gatherTexts(NodeImpl node, List<TextImpl> texts) {
        NodeImpl[] children = node.getChildrenArray();
        if (children == null) {
            return;
        }
        for (NodeImpl child : children) {
            if (child instanceof TextImpl) {
                texts.add((TextImpl)child);
                continue;
            }
            this.gatherTexts(child, texts);
        }
    }

    public CustomHTMLDocumentImpl getHtmlDocument() {
        return (CustomHTMLDocumentImpl)this.getRootNode();
    }

    public void setFocusable(boolean focusable) {
        super.setFocusable(focusable);
        if (this.htmlBlockPanel != null) {
            this.htmlBlockPanel.setFocusable(focusable);
        }
    }

    public URL getHtmlURL() {
        try {
            CustomHTMLDocumentImpl htmlDocument = this.getHtmlDocument();
            String documentURI = htmlDocument != null ? htmlDocument.getDocumentURI() : null;
            return documentURI != null ? new URL(documentURI) : null;
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }

    public void setHtmlURL(URL url) {
        try {
            this.setHtml(url.toURI().toString(), url.openStream());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            LogAPI.logSevere((Throwable)e);
        }
        catch (SAXException e) {
            LogAPI.logSevere((Throwable)e);
        }
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        String oldStatus = this.status;
        this.status = status;
        this.firePropertyChange("status", oldStatus, status);
    }

    void setHtml(String uri, InputStream htmlStream) throws UnsupportedEncodingException, IOException, SAXException {
        assert (!SwingUtilities.isEventDispatchThread());
        InputSourceImpl inputSource = new InputSourceImpl(htmlStream, uri, "UTF-8");
        CustomHTMLDocumentImpl document = this.rendererContext.createDocument((InputSource)inputSource);
        this.setDocument((Document)((Object)document), (HtmlRendererContext)this.rendererContext);
        Thread.yield();
        document.load();
    }

    public boolean isLoaded() {
        CustomHTMLDocumentImpl htmlDocument = this.getHtmlDocument();
        return htmlDocument != null ? htmlDocument.isLoaded() : false;
    }

    public boolean isBackEnabled() {
        return !this.history.isEmpty();
    }

    public void navigateBack() {
        URL oldDocumentURI = this.getHtmlURL();
        this.firePropertyChange("loaded", this.getHtmlDocument().isLoaded(), false);
        super.setDocument((Document)this.history.pop(), (HtmlRendererContext)this.rendererContext);
        if (this.history.isEmpty()) {
            this.firePropertyChange("backEnabled", true, false);
        }
        this.firePropertyChange("htmlURL", oldDocumentURI, this.getHtmlURL());
        this.firePropertyChange("loaded", false, this.getHtmlDocument().isLoaded());
        this.getHtmlDocument().addPropertyChangeListener("loaded", this.loadedForwarder);
    }

    public void setDocument(Document node, HtmlRendererContext rcontext) {
        HTMLDocument loggedDocument;
        CustomHTMLDocumentImpl oldDocument = this.getHtmlDocument();
        final URL oldDocumentURI = this.getHtmlURL();
        HTMLDocument hTMLDocument = loggedDocument = oldDocument != null ? (HTMLDocument)oldDocument.cloneNode(true) : null;
        if (this.loadedForwarder == null) {
            this.loadedForwarder = new PropertyChangeListener(){

                @Override
                public void propertyChange(final PropertyChangeEvent evt) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            HtmlPane.this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
                        }
                    });
                }
            };
        }
        if (oldDocument != null) {
            oldDocument.removePropertyChangeListener("loaded", this.loadedForwarder);
        }
        this.firePropertyChange("loaded", this.isLoaded(), false);
        super.setDocument(node, rcontext);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HtmlPane.this.firePropertyChange("htmlURL", oldDocumentURI, HtmlPane.this.getHtmlURL());
                HtmlPane.this.firePropertyChange("loaded", false, HtmlPane.this.getHtmlDocument().isLoaded());
                HtmlPane.this.getHtmlDocument().addPropertyChangeListener("loaded", HtmlPane.this.loadedForwarder);
                if (loggedDocument != null) {
                    HtmlPane.this.setCursor(null);
                    HtmlPane.this.history.push(loggedDocument);
                    if (HtmlPane.this.history.size() > 5) {
                        HtmlPane.this.history.remove(0);
                    } else if (HtmlPane.this.history.size() == 1) {
                        HtmlPane.this.firePropertyChange("backEnabled", false, true);
                    }
                }
            }
        });
    }

    public Point getScrollingOffset() {
        return this.scrollingOffset;
    }

    public void scrollRectToVisible(Rectangle rect) {
        int offset = 50;
        RBlock rblock = (RBlock)this.getBlockRenderable();
        Rectangle bounds = rblock.getBounds();
        bounds.setSize(bounds.width - 2 * offset, bounds.height - 2 * offset);
        bounds.translate(offset, offset);
        if (!bounds.contains(rect)) {
            if (bounds.y > rect.y) {
                rblock.scrollBy(1, rect.y - bounds.y);
            } else if (bounds.y + bounds.height < rect.y + rect.height) {
                rblock.scrollBy(1, rect.y + rect.height - bounds.y - bounds.height);
            }
            if (bounds.x > rect.x) {
                rblock.scrollBy(0, rect.x - bounds.x);
            } else if (bounds.x + bounds.width < rect.x + rect.width) {
                rblock.scrollBy(0, rect.x + rect.width - bounds.x - bounds.width);
            }
        }
    }

    private void setScrollingOffset(Point scrollingOffset) {
        Point oldOffset = this.scrollingOffset;
        this.scrollingOffset = scrollingOffset;
        this.firePropertyChange("scrollingOffset", oldOffset.clone(), scrollingOffset.clone());
    }

    protected HtmlBlockPanel createHtmlBlockPanel(UserAgentContext ucontext, HtmlRendererContext rcontext) {
        return new HtmlBlockPanel(Color.WHITE, true, ucontext, rcontext, (FrameContext)this){
            {
                this.setFocusable(true);
                this.setDefaultMarginInsets(HtmlPane.this.htmlComponentPaddingInsets);
            }

            public void setRootNode(NodeImpl node) {
                if (node != null) {
                    RBlock block = new RBlock(node, 0, this.ucontext, this.rcontext, this.frameContext, (RenderableContainer)this){

                        public void updateWidgetBounds(int guiX, int guiY) {
                            HtmlPane.this.setScrollingOffset(new Point(this.bodyLayout.x, this.bodyLayout.y));
                            super.updateWidgetBounds(guiX, guiY);
                        }
                    };
                    block.setDefaultOverflowX(2);
                    block.setDefaultOverflowY(2);
                    block.setDefaultMarginInsets(HtmlPane.this.htmlComponentPaddingInsets);
                    node.setUINode((UINode)block);
                    this.rblock = block;
                } else {
                    this.rblock = null;
                }
                this.invalidate();
                this.validateAll();
                this.repaint();
            }
        };
    }

    protected String getDocumentCharset(URLConnection connection) {
        return "UTF-8";
    }

    public void addPopupListener(PopupOwner popupOwner) {
        this.popupListeners.addListener((Object)popupOwner);
    }

    public void removePopupListener(PopupOwner popupOwner) {
        this.popupListeners.removeListener((Object)popupOwner);
    }

    void onContextMenu(MouseEvent event) {
        ((PopupOwner)this.popupListeners.getListener()).popupTriggered((JComponent)event.getComponent(), event.getPoint());
    }
}

