/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.html;

import com.selima.fbi.ui.content.html.CustomHTMLDocumentImpl;
import com.selima.fbi.ui.content.html.HtmlPane;
import com.selima.framework.threading.BackendOperationHandle;
import com.selima.framework.threading.BackendWork;
import com.selima.framework.threading.ISubmitter;
import com.selima.framework.threading.SwingOperationHandle;
import com.selima.framework.util.logging.LogAPI;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.lobobrowser.html.FormInput;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.gui.HtmlPanel;
import org.lobobrowser.html.io.WritableLineReader;
import org.lobobrowser.html.test.SimpleHtmlRendererContext;
import org.w3c.dom.Node;
import org.w3c.dom.UserDataHandler;
import org.w3c.dom.html2.HTMLBodyElement;
import org.w3c.dom.html2.HTMLElement;
import org.w3c.dom.html2.HTMLLinkElement;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class CustomHtmlRendererContext
extends SimpleHtmlRendererContext {
    static final Cursor HAND_CURSOR = Cursor.getPredefinedCursor(12);
    final CursorHandler cursorHandler = new CursorHandler();
    ISubmitter submitter;
    HtmlPane htmlPanel;

    public CustomHtmlRendererContext(HtmlPane htmlPanel, UserAgentContext ucontext) {
        super((HtmlPanel)htmlPanel, ucontext);
        this.htmlPanel = htmlPanel;
    }

    public CustomHTMLDocumentImpl createDocument(InputSource inputSource) throws IOException, SAXException {
        WritableLineReader wis;
        InputStream in;
        String uri;
        String charset = inputSource.getEncoding();
        if (charset == null) {
            charset = "US-ASCII";
        }
        if ((uri = inputSource.getSystemId()) == null) {
            LogAPI.logWarning((String)"parse(): InputSource has no SystemId (URI); document item URLs will not be resolvable.");
        }
        if ((in = inputSource.getByteStream()) != null) {
            wis = new WritableLineReader((Reader)new InputStreamReader(in, charset));
        } else {
            Reader reader = inputSource.getCharacterStream();
            if (reader != null) {
                wis = new WritableLineReader(reader);
            } else {
                throw new IllegalArgumentException("InputSource has neither a byte stream nor a character stream");
            }
        }
        CustomHTMLDocumentImpl document = new CustomHTMLDocumentImpl(this.getUserAgentContext(), (HtmlRendererContext)this, wis, uri);
        return document;
    }

    protected boolean isNavigationAsynchronous() {
        return this.submitter == null;
    }

    void setSubmitter(ISubmitter submitter) {
        this.submitter = submitter;
    }

    protected void submitFormSync(final String method, final URL action, final String target, final String enctype, final FormInput[] formInputs) throws IOException, SAXException {
        if (this.submitter != null) {
            this.submitter.submitWork(new BackendWork(){

                public String getName() {
                    return "Loading " + action;
                }

                public void invokeBackend(BackendOperationHandle handle) {
                    try {
                        CustomHtmlRendererContext.super.submitFormSync(method, action, target, enctype, formInputs);
                    }
                    catch (IOException e) {
                        handle.setFailure((Throwable)e);
                    }
                    catch (SAXException e) {
                        handle.setFailure((Throwable)e);
                    }
                }

                public void invokeSwing(SwingOperationHandle handle) {
                    if (handle.getFailure() != null) {
                        LogAPI.logSevere((Throwable)handle.getFailure());
                    }
                }
            });
        } else {
            super.submitFormSync(method, action, target, enctype, formInputs);
        }
    }

    public void linkClicked(HTMLElement linkNode, URL url, String target) {
        try {
            if (!InetAddress.getByName(url.getHost()).isLoopbackAddress()) {
                Desktop.getDesktop().browse(url.toURI());
            } else if ("mailto".equals(url.getProtocol())) {
                Desktop.getDesktop().mail(url.toURI());
            } else {
                this.navigate(url, target);
            }
            this.markVisitedLink(linkNode);
        }
        catch (UnknownHostException e) {
            LogAPI.logSevere((Throwable)e);
        }
        catch (IOException e) {
            Toolkit.getDefaultToolkit().beep();
            LogAPI.logSevere((Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    private void markVisitedLink(HTMLElement linkNode) {
        linkNode.setUserData("visited-flag", (Object)Boolean.TRUE, new UserDataHandler(){

            @Override
            public void handle(short operation, String key, Object data, Node src, Node dst) {
                if (src != null && dst != null && "visited-flag".equals(key)) {
                    dst.setUserData(key, data, this);
                }
            }
        });
    }

    public boolean isVisitedLink(HTMLLinkElement link) {
        return link.getUserData("visited-flag") == Boolean.TRUE;
    }

    public void onMouseOut(HTMLElement element, MouseEvent event) {
        this.cursorHandler.onMouseOut((Node)element);
    }

    public void onMouseOver(HTMLElement element, MouseEvent event) {
        this.cursorHandler.onMouseOver((Node)element);
    }

    public boolean onContextMenu(HTMLElement element, MouseEvent event) {
        if (element instanceof HTMLBodyElement) {
            this.htmlPanel.onContextMenu(event);
        }
        return true;
    }

    public void setStatus(String message) {
        this.htmlPanel.setStatus(message);
    }

    class CursorHandler
    implements Runnable {
        private boolean running;

        CursorHandler() {
        }

        void onMouseOut(Node element) {
            Set<Node> hoveringLinks;
            assert (SwingUtilities.isEventDispatchThread());
            if (!this.running) {
                this.running = true;
                SwingUtilities.invokeLater(this);
            }
            if ((hoveringLinks = this.hoveringLinks(element, false)) != null) {
                hoveringLinks.remove(element);
            }
        }

        void onMouseOver(Node element) {
            assert (SwingUtilities.isEventDispatchThread());
            if (!this.running) {
                this.running = true;
                SwingUtilities.invokeLater(this);
            }
            if (element instanceof HTMLLinkElement) {
                this.hoveringLinks(element, true).add(element);
            }
        }

        @Override
        public void run() {
            Cursor desiredCursor;
            Set hoveringLinks = (Set)CustomHtmlRendererContext.this.htmlPanel.getRootNode().getUserData("hoveringLinks");
            Cursor cursor = desiredCursor = hoveringLinks == null || hoveringLinks.isEmpty() ? null : Cursor.getPredefinedCursor(12);
            if (CustomHtmlRendererContext.this.htmlPanel.getCursor() != desiredCursor) {
                CustomHtmlRendererContext.this.htmlPanel.setCursor(desiredCursor);
            }
            this.running = false;
        }

        private Set<Node> hoveringLinks(Node element, boolean create) {
            Node parentNode = element.getParentNode();
            while (parentNode != null) {
                element = parentNode;
                parentNode = element.getParentNode();
            }
            HashSet hoveringLinks = (HashSet)element.getUserData("hoveringLinks");
            if (hoveringLinks == null && create) {
                hoveringLinks = new HashSet();
                element.setUserData("hoveringLinks", hoveringLinks, null);
            }
            return hoveringLinks;
        }
    }
}

