/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.empsel;

import com.selima.fbi.ui.common.EmpRefCellRenderer;
import com.selima.fbi.ui.content.empsel.EmpSelectionEvent;
import com.selima.fbi.ui.content.empsel.EmpSelectionListener;
import com.selima.fbi.ui.content.empsel.EmpSelectionModel;
import com.selima.fbi.user.IEmpRefListener;
import com.selima.fbi.user.IReferenceManager;
import com.selima.fbi.user.IUser;
import com.selima.framework.threading.EventBroadcast;
import com.selima.framework.threading.EventBroadcastFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

class EmpSelectionList
extends JList {
    public EmpSelectionList(IUser user, EmpSelectionModel empModel, IReferenceManager referenceManager) {
        this(new EmpRefsListModel(user), empModel, referenceManager);
    }

    private EmpSelectionList(EmpRefsListModel listModel, EmpSelectionModel empModel, IReferenceManager referenceManager) {
        super(listModel);
        this.setSelectionModel(new CustomSelectionModel(empModel, listModel));
        this.setCellRenderer(new EmpRefCellRenderer(referenceManager, this.getCellRenderer()));
        this.addAncestorListener(listModel);
        new LeadFocusListener();
        this.setOpaque(false);
        this.setBackground(new Color(255, 255, 225, 196));
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        int size = this.getModel().getSize();
        if (size > 0) {
            this.setVisibleRowCount(Math.min(20, size));
            return super.getPreferredScrollableViewportSize();
        }
        Component rendererComponent = this.getCellRenderer().getListCellRendererComponent(this, "XXX/YYYYY", 0, false, false);
        return rendererComponent.getPreferredSize();
    }

    void refreshData() {
        this.getModel().refreshData();
    }

    public EmpRefsListModel getModel() {
        return (EmpRefsListModel)super.getModel();
    }

    static class EmpRefsListModel
    implements ListModel,
    IEmpRefListener,
    AncestorListener {
        IUser user;
        EventBroadcast<ListDataListener> listeners = EventBroadcastFactory.createEventBroadcast(ListDataListener.class);
        List<String> empRefs;

        EmpRefsListModel(IUser user) {
            this.user = user;
            this.empRefs = new ArrayList<String>(Arrays.asList(user.getEmpRef()));
        }

        @Override
        public int getSize() {
            return this.empRefs.size();
        }

        public Object getElementAt(int index) {
            return this.empRefs.get(index);
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.listeners.addListener((Object)l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.listeners.removeListener((Object)l);
        }

        void dispose() {
            this.user.removeEmpRefListener(this);
        }

        void refreshData() {
            ArrayList<String> newRefs = new ArrayList<String>(Arrays.asList(this.user.getEmpRef()));
            if (!newRefs.equals(this.empRefs)) {
                int size = this.getSize();
                this.empRefs = newRefs;
                size = Math.max(size, this.getSize());
                ((ListDataListener)this.listeners.getListener()).intervalAdded(new ListDataEvent(this, 0, 0, size));
            }
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
            this.refreshData();
            this.user.addEmpRefListener(this);
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
            this.user.removeEmpRefListener(this);
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }

        @Override
        public void added(final IUser user, final String ref, final int index) {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.added(user, ref, index);
                    }
                });
                return;
            }
            this.empRefs.add(index, ref);
            ((ListDataListener)this.listeners.getListener()).intervalAdded(new ListDataEvent(this, 1, index, index));
        }

        @Override
        public void removed(final IUser user, final String ref, final int index) {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.removed(user, ref, index);
                    }
                });
                return;
            }
            this.empRefs.remove(index);
            ((ListDataListener)this.listeners.getListener()).intervalRemoved(new ListDataEvent(this, 2, index, index));
        }
    }

    static class CustomSelectionModel
    extends DefaultListSelectionModel
    implements EmpSelectionListener {
        EmpSelectionModel empModel;
        ListModel listModel;

        CustomSelectionModel(EmpSelectionModel empModel, ListModel listModel) {
            this.empModel = empModel;
            this.listModel = listModel;
            this.setSelectionMode(2);
            this.synchronizeSuper();
            empModel.addListener(this);
        }

        @Override
        public void addSelectionInterval(int index0, int index1) {
            super.addSelectionInterval(index0, index1);
            this.synchronizeEmps();
        }

        @Override
        public void clearSelection() {
            super.clearSelection();
            this.synchronizeEmps();
        }

        @Override
        public void setSelectionInterval(int index0, int index1) {
            super.setSelectionInterval(index0, index1);
            this.synchronizeEmps();
        }

        @Override
        public void removeIndexInterval(int index0, int index1) {
            super.removeIndexInterval(index0, index1);
            this.synchronizeEmps();
        }

        @Override
        public void removeSelectionInterval(int index0, int index1) {
            super.removeSelectionInterval(index0, index1);
            this.synchronizeEmps();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void synchronizeEmps() {
            for (int i = 0; i < this.listModel.getSize(); ++i) {
                String value = (String)this.listModel.getElementAt(i);
                if (super.isSelectedIndex(i) == this.empModel.isSelected(value)) continue;
                CustomSelectionModel customSelectionModel = this;
                synchronized (customSelectionModel) {
                    if (super.isSelectedIndex(i)) {
                        this.empModel.select(value);
                    } else {
                        this.empModel.unselect(value);
                    }
                    continue;
                }
            }
        }

        private void synchronizeSuper() {
            for (int i = 0; i < this.listModel.getSize(); ++i) {
                if (this.empModel.isSelected((String)this.listModel.getElementAt(i))) {
                    super.addSelectionInterval(i, i);
                    continue;
                }
                super.removeSelectionInterval(i, i);
            }
        }

        @Override
        public void selectionChange(EmpSelectionEvent evt) {
            if (!Thread.holdsLock(this)) {
                this.synchronizeSuper();
            }
        }
    }

    class LeadFocusListener
    extends FocusAdapter {
        LeadFocusListener() {
            EmpSelectionList.this.addFocusListener(this);
        }

        @Override
        public void focusGained(FocusEvent evt) {
            if (EmpSelectionList.this.getLeadSelectionIndex() == -1 && EmpSelectionList.this.getModel().getSize() > 0) {
                EmpSelectionList.this.getSelectionModel().setAnchorSelectionIndex(0);
                EmpSelectionList.this.getSelectionModel().setLeadSelectionIndex(0);
            }
        }
    }
}

