/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.empsel;

import com.selima.fbi.ui.content.empsel.EmpSelectionEvent;
import com.selima.fbi.ui.content.empsel.EmpSelectionListener;
import com.selima.fbi.ui.content.empsel.EmpSelectionModel;
import com.selima.fbi.user.IReferenceManager;
import java.awt.Color;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JTextField;

class EmpSelectionField
extends JTextField {
    Color defaultForground;
    IReferenceManager refManager;

    public EmpSelectionField(EmpSelectionModel model, IReferenceManager refManager) {
        this.refManager = refManager;
        model.addListener(new SelectionListener());
        Dimension dim = new Dimension(75, 20);
        this.setPreferredSize(dim);
        this.setMaximumSize(dim);
        this.setMinimumSize(dim);
        this.setFocusable(false);
        this.setEditable(false);
        this.defaultForground = this.getForeground();
        this.setBackground(new Color(255, 255, 225));
        this.setText(this.text(model));
        this.setToolTipText(this.tooltip(model));
        this.setForeground(this.foreground(model));
    }

    Color foreground(EmpSelectionModel model) {
        return model.isActiveSearch() || model.getSelected().size() > 0 ? this.defaultForground : Color.RED;
    }

    String text(EmpSelectionModel model) {
        if (model.isActiveSearch()) {
            return "Search";
        }
        List<String> empRefs = model.getSelected();
        switch (empRefs.size()) {
            case 0: {
                return "Nothing";
            }
            case 1: {
                return empRefs.get(0);
            }
        }
        return empRefs.size() + " References";
    }

    String tooltip(EmpSelectionModel model) {
        if (model.isActiveSearch()) {
            return "Search for new references, download all";
        }
        List<String> empRefs = model.getSelected();
        if (empRefs.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder(empRefs.size() * 14);
        result.append("<html><div>");
        for (String empRef : empRefs) {
            String description = this.refManager.getFullReference(empRef).getDescription();
            if (description == null) {
                description = "";
            }
            result.append("<b>").append(empRef).append("</b>").append(" ").append(description).append("<BR>");
        }
        result.append("</div></html>");
        return result.toString();
    }

    class SelectionListener
    implements EmpSelectionListener {
        SelectionListener() {
        }

        @Override
        public void selectionChange(EmpSelectionEvent evt) {
            EmpSelectionField.this.setText(EmpSelectionField.this.text(evt.getSource()));
            EmpSelectionField.this.setToolTipText(EmpSelectionField.this.tooltip(evt.getSource()));
            EmpSelectionField.this.setForeground(EmpSelectionField.this.foreground(evt.getSource()));
        }
    }
}

