/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.editors;

import com.selima.fbi.core.payebeans.PropertyValidationException;
import com.selima.fbi.ui.content.editors.IEditorProperty;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public abstract class WrappingProperty
implements IEditorProperty,
PropertyChangeListener {
    final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    protected final IEditorProperty wrappedProperty;

    public WrappingProperty(IEditorProperty editorProperty) {
        this.wrappedProperty = editorProperty;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (!this.changeSupport.hasListeners(null)) {
            this.wrappedProperty.addPropertyChangeListener(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
        if (!this.changeSupport.hasListeners(null)) {
            this.wrappedProperty.removePropertyChangeListener(this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.changeSupport.firePropertyChange(evt.getPropertyName(), this.toInternal(evt.getOldValue()), this.toInternal(evt.getNewValue()));
    }

    @Override
    public Object get() {
        return this.toInternal(this.wrappedProperty.get());
    }

    @Override
    public boolean isReadonly() {
        return this.wrappedProperty.isReadonly();
    }

    @Override
    public void set(Object value) throws PropertyValidationException {
        this.wrappedProperty.set(this.toExternal(value));
    }

    @Override
    public boolean isResetable() {
        return this.wrappedProperty.isResetable();
    }

    @Override
    public void reset() {
        this.wrappedProperty.reset();
    }

    abstract Object toInternal(Object var1);

    abstract Object toExternal(Object var1);

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.wrappedProperty.toString();
    }
}

