/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.editors;

import com.selima.fbi.core.payebeans.PropertyValidationException;
import com.selima.fbi.ui.common.SwingHelper;
import com.selima.fbi.ui.content.editors.EditorWidgetSPI;
import com.selima.fbi.ui.content.editors.IEditorProperty;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicFormattedTextFieldUI;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.JTextComponent;
import javax.swing.text.NumberFormatter;

public class NumberFieldWidget
extends JFormattedTextField
implements EditorWidgetSPI,
PropertyChangeListener {
    IEditorProperty property;
    private boolean selfUpdate;

    NumberFieldWidget(IEditorProperty property, NumberFormat format) {
        this(property, new DefaultFormatterFactory(new NumberFormatter(format)));
        this.getFormatter().setCommitsOnValidEdit(true);
        this.getFormatter().setValueClass(Long.class);
    }

    NumberFieldWidget(IEditorProperty property, JFormattedTextField.AbstractFormatterFactory factory) {
        super(factory);
        this.property = property;
        this.setForeground(FONT_COLOR);
        this.setFont(Font.getFont(FONT_STYLE));
        this.setUI(new BasicFormattedTextFieldUI());
        this.setBorder(BorderFactory.createEmptyBorder());
        property.addPropertyChangeListener(this);
        this.addPropertyChangeListener("editValid", this);
        this.addPropertyChangeListener("value", this);
        this.setFocusLostBehavior(0);
        if (property.isReadonly()) {
            this.setEditable(false);
            this.setBackground(READONLY_BACKGROUND);
        } else {
            this.setBackground(DEFAULT_BACKGROUND);
        }
        this.setValue(property.get());
    }

    @Override
    public NumberFormatter getFormatter() {
        return (NumberFormatter)super.getFormatter();
    }

    @Override
    public Point getAdditionalOffset() {
        return new Point(4, 1);
    }

    @Override
    public void setDivWidth(int width) {
        Dimension dim = this.getPreferredSize();
        dim.width = width;
        this.setPreferredSize(dim);
    }

    @Override
    public void detach() {
        this.property.removePropertyChangeListener(this);
    }

    @Override
    public JComponent toComponent() {
        return this;
    }

    @Override
    public void setValue(Object value) {
        if (!this.selfUpdate) {
            this.selfUpdate = !this.isEditable();
            try {
                super.setValue(value);
            }
            finally {
                this.selfUpdate = false;
            }
        }
    }

    void setProperty(Object value) {
        if (!this.selfUpdate) {
            this.selfUpdate = true;
            try {
                this.property.set(value);
                this.showValid();
            }
            catch (PropertyValidationException e) {
                this.showInvalid(e.getMessage());
            }
            finally {
                this.selfUpdate = false;
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this) {
            String propertyName = evt.getPropertyName();
            if ("editValid".equals(propertyName)) {
                if (Boolean.FALSE == evt.getNewValue()) {
                    this.showInvalid("Not a valid number according to format required");
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            NumberFieldWidget.this.setProperty(NumberFieldWidget.this.getValue());
                        }
                    });
                }
            } else {
                this.setProperty(evt.getNewValue());
            }
        } else {
            this.setValue(evt.getNewValue());
        }
    }

    protected void showInvalid(String message) {
        this.setBackground(INVALID_BACKGROUND);
    }

    protected void showValid() {
        this.setBackground(DEFAULT_BACKGROUND);
    }

    @Override
    public boolean isResetable() {
        return this.property.isResetable();
    }

    @Override
    public void resetToPayroll() {
        this.property.reset();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.property + "]";
    }

    @Override
    public Action[] getPopupActions() {
        return new Action[]{new ResetAction()};
    }

    @Override
    public Point preferredPopupPoint() {
        int x;
        try {
            x = this.getUI().modelToView((JTextComponent)this, (int)this.getCaretPosition()).x;
        }
        catch (Exception e) {
            x = 3;
        }
        int y = this.getHeight() - 3;
        return new Point(x, y);
    }

    class ResetAction
    extends AbstractAction {
        ResetAction() {
            super("Reset field", SwingHelper.imageIcon("/img/16x16/actions/reset_field.png"));
            this.setEnabled(NumberFieldWidget.this.property.isResetable());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NumberFieldWidget.this.resetToPayroll();
        }
    }
}

