/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.editors;

import com.selima.fbi.ui.content.editors.IEditorProperty;
import com.selima.fbi.ui.content.editors.NumberFieldWidget;
import com.selima.fbi.ui.content.editors.StrictDecimalFormat;
import com.selima.fbi.ui.content.editors.WrappingProperty;
import java.math.BigDecimal;
import javax.swing.UIManager;

public class MoneyField
extends NumberFieldWidget {
    private final boolean windowsLookAndFeel;
    private String defaultTooltip;

    MoneyField(IEditorProperty property, String tooltip) {
        super((IEditorProperty)new BigDecimalProperty(property), new StrictDecimalFormat("0.00"));
        this.getFormatter().setValueClass(Double.class);
        this.windowsLookAndFeel = "Windows".equals(UIManager.getLookAndFeel().getID());
        this.setHorizontalAlignment(4);
        if (tooltip != null) {
            this.defaultTooltip = (this.windowsLookAndFeel ? "<html><p style='width:250px;padding:10px;margin:0px;'>" : "<html><p style='width:275px;padding:10px;margin:0px;font-size:small;'>") + tooltip.replaceAll("\n", "<BR>") + "</p></html>";
            if (this.getToolTipText() == null) {
                this.setToolTipText(this.defaultTooltip);
            }
        }
    }

    @Override
    protected void showInvalid(String message) {
        super.showInvalid(message);
        this.setToolTipText("<html><body style='background:#FFE2E2;color:black;padding:10px;margin:0px;width:275px'>" + message + "</body></html>");
    }

    @Override
    protected void showValid() {
        super.showValid();
        this.setToolTipText(this.defaultTooltip);
    }

    static class BigDecimalProperty
    extends WrappingProperty {
        public BigDecimalProperty(IEditorProperty editorProperty) {
            super(editorProperty);
        }

        @Override
        Object toExternal(Object value) {
            if (value instanceof Number) {
                value = BigDecimal.valueOf(((Number)value).doubleValue());
            }
            return value;
        }

        @Override
        Object toInternal(Object value) {
            return value;
        }
    }
}

