/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.editors;

import com.selima.fbi.core.IMailMessage;
import com.selima.fbi.core.payebeans.IBeanMessage;
import com.selima.fbi.ui.common.PopupOwner;
import com.selima.fbi.ui.common.SwingHelper;
import com.selima.fbi.ui.content.editors.DefaultEditorWidgetFactory;
import com.selima.fbi.ui.content.editors.DefaultPrintingDetailsFactory;
import com.selima.fbi.ui.content.editors.EditorWidget;
import com.selima.fbi.ui.content.editors.EditorWidgetFactory;
import com.selima.fbi.ui.content.editors.MessageBrowserCyclePolicy;
import com.selima.fbi.ui.content.editors.PrintingDetailsFactory;
import com.selima.fbi.ui.content.html.HtmlPane;
import com.selima.fbi.ui.content.html.PrintingDetails;
import com.selima.fbi.webserver.PagePart;
import com.selima.framework.threading.ISubmitter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.w3c.dom.html2.HTMLDocument;

public class MessageBrowser
extends JPanel
implements PropertyChangeListener {
    PrintingDetailsFactory printingDetailsFactory;
    List<? extends EditorWidget> editors;
    EditorWidgetFactory editorFactory;
    PrintingDetails printingDetails;
    AutoScroller autoScroller;
    JLayeredPane layeredPane;
    EditorWidget lastEditor;
    Action[] actions;
    HtmlPane htmlPane;
    PagePart pagePart;
    boolean fieldResetable;
    boolean pageResetable;

    public MessageBrowser(IMailMessage message, Insets insets, String title, Action ... actions) {
        super(new BorderLayout());
        this.actions = actions;
        this.setOpaque(false);
        this.editors = new LinkedList<EditorWidget>();
        if (message instanceof IBeanMessage) {
            this.editorFactory = new DefaultEditorWidgetFactory(title, (IBeanMessage)message, insets);
        }
        this.printingDetailsFactory = new DefaultPrintingDetailsFactory();
        this.htmlPane = new HtmlPane(insets);
        this.htmlPane.addPropertyChangeListener("loaded", this);
        this.htmlPane.addPropertyChangeListener("htmlURL", this);
        this.htmlPane.addPropertyChangeListener("backEnabled", this);
        this.htmlPane.addPropertyChangeListener("scrollingOffset", this);
        this.htmlPane.addPopupListener(new HtmlPanePopupOwner());
        this.layeredPane = new JLayeredPane();
        this.layeredPane.setOpaque(false);
        this.layeredPane.add((Component)((Object)this.htmlPane), JLayeredPane.DEFAULT_LAYER);
        this.add(this.layeredPane);
        this.setFocusTraversalPolicy(new MessageBrowserCyclePolicy());
        new FocusedTracker().attach();
    }

    @Override
    public void doLayout() {
        super.doLayout();
        this.htmlPane.setSize(this.layeredPane.getSize());
    }

    public void detach() {
        for (EditorWidget editorWidget : this.editors) {
            editorWidget.detach();
            this.layeredPane.remove(editorWidget.toComponent());
            editorWidget.toComponent().removeFocusListener(this.autoScroller);
        }
        this.editors.clear();
        this.setFocusTraversalPolicyProvider(false);
        this.htmlPane.setFocusable(false);
        this.setPageResetable(false);
        this.setLastEditor(null);
    }

    void attach() {
        assert (this.editors.isEmpty());
        if (this.editorFactory != null) {
            boolean pageResetable = false;
            this.editors = this.editorFactory.create((HTMLDocument)this.htmlPane.getHtmlDocument());
            for (EditorWidget editorWidget : this.editors) {
                if (this.autoScroller == null) {
                    this.autoScroller = new AutoScroller();
                }
                JComponent editorComponent = editorWidget.toComponent();
                editorComponent.addFocusListener(this.autoScroller);
                this.layeredPane.add((Component)editorComponent, JLayeredPane.PALETTE_LAYER);
                pageResetable = pageResetable || editorWidget.isResetable();
                SwingHelper.installPopupTrigger(editorComponent, new EditorPopupOwner(editorWidget));
            }
            this.setPageResetable(pageResetable);
            this.setFocusTraversalPolicyProvider(!this.editors.isEmpty());
            this.htmlPane.setFocusable(!this.editors.isEmpty());
        }
        if (this.printingDetailsFactory != null) {
            PrintingDetails oldDetails = this.printingDetails;
            this.printingDetails = this.printingDetailsFactory.resolve((HTMLDocument)this.htmlPane.getHtmlDocument());
            this.firePropertyChange("printingDetails", oldDetails, this.printingDetails);
        }
    }

    public URL getHtmlURL() {
        return this.htmlPane.getHtmlURL();
    }

    public PagePart getPagePart() {
        return this.pagePart;
    }

    public boolean isFieldResetable() {
        return this.fieldResetable;
    }

    public void resetFieldToPayroll() {
        this.lastEditor.resetToPayroll();
    }

    public boolean isPageResetable() {
        return this.pageResetable;
    }

    public void resetPageToPayroll() {
        for (EditorWidget editorWidget : this.editors) {
            if (!editorWidget.isResetable()) continue;
            editorWidget.resetToPayroll();
        }
    }

    public void setPagePart(PagePart pagePart) {
        if (this.equals(pagePart, this.pagePart)) {
            return;
        }
        PagePart oldPagePart = pagePart;
        this.pagePart = pagePart;
        this.htmlPane.setHtmlURL(pagePart.url);
        this.firePropertyChange("pagePart", oldPagePart, pagePart);
    }

    public boolean isBackEnabled() {
        return this.htmlPane.isBackEnabled();
    }

    public void navigateBack() {
        this.htmlPane.navigateBack();
    }

    public PrintingDetails getPrintingDetails() {
        return this.printingDetails;
    }

    public void highlight(String text) {
        this.htmlPane.highlight(text);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.htmlPane) {
            if ("htmlURL".equals(evt.getPropertyName())) {
                this.detach();
            }
            if ("loaded".equals(evt.getPropertyName()) && Boolean.TRUE.equals(evt.getNewValue())) {
                this.attach();
            }
            if ("scrollingOffset".equals(evt.getPropertyName())) {
                Point oldOffset = (Point)evt.getOldValue();
                Point curOffset = (Point)evt.getNewValue();
                this.moveEditors(curOffset, oldOffset);
            }
            this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }
    }

    private void moveEditors(Point curOffset, Point oldOffset) {
        if (this.editors.isEmpty()) {
            return;
        }
        curOffset.translate(-oldOffset.x, -oldOffset.y);
        for (EditorWidget editorWidget : this.editors) {
            Point location = editorWidget.toComponent().getLocation();
            location.translate(curOffset.x, curOffset.y);
            editorWidget.toComponent().setLocation(location);
        }
    }

    private boolean equals(Object object1, Object object2) {
        return object1 != null ? object1.equals(object2) : object2 == null;
    }

    private void setFieldResetable(boolean state) {
        boolean oldState = this.fieldResetable;
        this.fieldResetable = state;
        this.firePropertyChange("fieldResetable", oldState, state);
    }

    private void setPageResetable(boolean state) {
        boolean oldState = this.pageResetable;
        this.pageResetable = state;
        this.firePropertyChange("pageResetable", oldState, state);
    }

    private void setLastEditor(EditorWidget editor) {
        this.lastEditor = editor;
        this.setFieldResetable(this.lastEditor != null && this.lastEditor.isResetable());
    }

    public void setSubmitter(ISubmitter submitter) {
        this.htmlPane.setSubmitter(submitter);
    }

    class HtmlPanePopupOwner
    implements PopupOwner {
        HtmlPanePopupOwner() {
        }

        @Override
        public void popupTriggered(JComponent source, Point point) {
            JPopupMenu menu = new JPopupMenu();
            for (Action action : MessageBrowser.this.actions) {
                if ("hide".equals(action.getValue("popupMenu")) || Boolean.FALSE.equals(action.getValue("visible"))) continue;
                menu.add(action);
            }
            menu.show(source, point.x, point.y);
        }
    }

    class EditorPopupOwner
    implements PopupOwner {
        final EditorWidget editor;

        EditorPopupOwner(EditorWidget editor) {
            this.editor = editor;
        }

        @Override
        public void popupTriggered(JComponent source, Point point) {
            if (point == null) {
                point = this.editor.preferredPopupPoint();
            }
            LinkedHashMap<String, Action> map = new LinkedHashMap<String, Action>();
            for (Action action : MessageBrowser.this.actions) {
                map.put((String)action.getValue("Name"), action);
            }
            for (Action action : this.editor.getPopupActions()) {
                map.put((String)action.getValue("Name"), action);
            }
            JPopupMenu menu = new JPopupMenu();
            for (Action action : map.values()) {
                if ("hide".equals(action.getValue("popupMenu")) || Boolean.FALSE.equals(action.getValue("visible"))) continue;
                menu.add(action);
            }
            menu.show(source, point.x, point.y);
        }
    }

    class FocusedTracker
    implements PropertyChangeListener,
    AncestorListener {
        Timer timer;

        FocusedTracker() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Component focusOwner = (Component)evt.getNewValue();
            if (focusOwner != null) {
                for (EditorWidget editorWidget : MessageBrowser.this.editors) {
                    if (!SwingUtilities.isDescendingFrom(focusOwner, editorWidget.toComponent())) continue;
                    if (this.timer != null) {
                        this.timer.stop();
                    }
                    MessageBrowser.this.setLastEditor(editorWidget);
                    return;
                }
                if (!(MessageBrowser.this.lastEditor == null || this.timer != null && this.timer.isRunning())) {
                    if (this.timer == null) {
                        this.timer = new Timer(500, new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                MessageBrowser.this.setLastEditor(null);
                            }
                        });
                        this.timer.setRepeats(false);
                        this.timer.start();
                    } else {
                        this.timer.start();
                    }
                }
            }
        }

        void attach() {
            MessageBrowser.this.addAncestorListener(this);
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", this);
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("focusOwner", this);
        }
    }

    class AutoScroller
    extends FocusAdapter {
        AutoScroller() {
        }

        @Override
        public void focusGained(FocusEvent evt) {
            MessageBrowser.this.htmlPane.scrollRectToVisible(evt.getComponent().getBounds());
        }
    }
}

