/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.editors;

import com.selima.fbi.ui.content.editors.IEditorProperty;
import com.selima.fbi.ui.content.editors.NumberFieldWidget;
import com.selima.fbi.ui.content.editors.WrappingProperty;
import java.text.DecimalFormat;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.UIManager;
import javax.swing.text.NumberFormatter;

public class IntegerField
extends NumberFieldWidget {
    private String defaultTooltip;

    IntegerField(IEditorProperty property, String tooltip) {
        super((IEditorProperty)new IntProperty(property), new NullableFormatterFactory());
        this.setHorizontalAlignment(4);
        String tooltipProlog = "Windows".equals(UIManager.getLookAndFeel().getID()) ? "<html><p style='width:250px;padding:10px;margin:0px;'>" : "<html><p style='width:275px;padding:10px;margin:0px;font-size:small;'>";
        this.defaultTooltip = tooltipProlog + tooltip.replaceAll("\n", "<br>") + "</p></html>";
        this.setToolTipText(this.defaultTooltip);
    }

    @Override
    protected void showValid() {
        super.showValid();
        this.setToolTipText(this.defaultTooltip);
    }

    @Override
    protected void showInvalid(String message) {
        super.showInvalid(message);
        this.setToolTipText("<html><body style='background:#FFE2E2;color:black;padding:10px;margin:0px;width:275px'>" + message + "</body></html>");
    }

    static class NullableNumberFormatter
    extends NumberFormatter {
        public NullableNumberFormatter() {
            super(new DecimalFormat("#"));
        }

        @Override
        public Object stringToValue(String text) throws ParseException {
            return text.length() > 0 ? super.stringToValue(text) : null;
        }
    }

    static class NullableFormatterFactory
    extends JFormattedTextField.AbstractFormatterFactory {
        NullableFormatterFactory() {
        }

        @Override
        public JFormattedTextField.AbstractFormatter getFormatter(JFormattedTextField tf) {
            return new NullableNumberFormatter();
        }
    }

    static class IntProperty
    extends WrappingProperty {
        public IntProperty(IEditorProperty editorProperty) {
            super(editorProperty);
        }

        @Override
        Object toExternal(Object value) {
            Number number = (Number)value;
            return number == null ? null : Integer.valueOf(number.intValue());
        }

        @Override
        Object toInternal(Object value) {
            Number number = (Number)value;
            return number == null ? null : Integer.valueOf(number.intValue());
        }
    }
}

