/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.editors;

import com.selima.fbi.ui.content.editors.AbstractPIBasedFactory;
import com.selima.fbi.ui.content.editors.PrintingDetailsFactory;
import com.selima.fbi.ui.content.html.PrintingDetails;
import com.selima.fbi.ui.content.html.SinglePagePortrait;
import com.selima.fbi.ui.content.html.TwoPageLandscape;
import java.util.Map;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.html2.HTMLDocument;

public class DefaultPrintingDetailsFactory
extends AbstractPIBasedFactory<PrintingDetails>
implements PrintingDetailsFactory {
    @Override
    public PrintingDetails resolve(HTMLDocument document) {
        PrintingDetails result = (PrintingDetails)this.traverse(document);
        return result != null ? result : new SinglePagePortrait();
    }

    @Override
    protected PrintingDetails process(ProcessingInstruction pi) {
        block9: {
            if ("printing-details".equals(pi.getTarget())) {
                Map<String, String> params = this.parsePIData(pi.getData());
                String mode = params.get("mode");
                if ("two-page-landscape".equals(mode)) {
                    try {
                        String divider = params.get("divider");
                        return new TwoPageLandscape(Integer.parseInt(divider));
                    }
                    catch (NullPointerException e) {
                        assert (false) : "Missing divider in " + pi;
                        break block9;
                    }
                    catch (NumberFormatException e) {
                        assert (false) : "Invalid divider in " + pi;
                        break block9;
                    }
                }
                if ("single-page-portrait".equals(mode)) {
                    return new SinglePagePortrait();
                }
                assert (false) : "Unexpected printing-mode (typo?) [" + mode + "] in " + pi;
            }
        }
        return null;
    }
}

