/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.editors;

import com.selima.fbi.core.payebeans.IBeanMessage;
import com.selima.fbi.ui.content.editors.AbstractPIBasedFactory;
import com.selima.fbi.ui.content.editors.DateField;
import com.selima.fbi.ui.content.editors.EditorWidget;
import com.selima.fbi.ui.content.editors.EditorWidgetFactory;
import com.selima.fbi.ui.content.editors.EditorWidgetSPI;
import com.selima.fbi.ui.content.editors.FractionPartField;
import com.selima.fbi.ui.content.editors.IEditorProperty;
import com.selima.fbi.ui.content.editors.IntField;
import com.selima.fbi.ui.content.editors.IntegerField;
import com.selima.fbi.ui.content.editors.IntegerPartField;
import com.selima.fbi.ui.content.editors.MoneyField;
import com.selima.fbi.ui.content.editors.ReflectiveProperty;
import com.selima.fbi.ui.content.editors.StringCheckBox;
import com.selima.fbi.ui.content.editors.YesBox;
import com.selima.fbi.ui.content.editors.YesNoBox;
import com.selima.framework.util.logging.LogAPI;
import java.awt.Insets;
import java.awt.Point;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.html2.HTMLDocument;

class DefaultEditorWidgetFactory
extends AbstractPIBasedFactory<Void>
implements EditorWidgetFactory {
    final Pattern cssPropertyPattern = Pattern.compile("\\s*(\\d+)px");
    final IBeanMessage message;
    final Insets insets;
    final String title;
    private List<EditorWidget> editors;

    DefaultEditorWidgetFactory(String title, IBeanMessage message, Insets insets) {
        this.message = message;
        this.insets = insets;
        this.title = title;
    }

    @Override
    public List<? extends EditorWidget> create(HTMLDocument document) {
        this.editors = new LinkedList<EditorWidget>();
        try {
            this.traverse(document);
            List<EditorWidget> list = this.editors;
            return list;
        }
        finally {
            this.editors = null;
        }
    }

    @Override
    protected Void process(ProcessingInstruction pi) {
        if ("editor".equals(pi.getTarget())) {
            this.editors.add(this.createEditor(pi));
        }
        return null;
    }

    private EditorWidget createEditor(ProcessingInstruction pi) {
        EditorWidgetSPI result = this.createEditor(pi.getData());
        int left = -1;
        int top = -1;
        int width = -1;
        for (Node n = pi.getParentNode(); n != null && (left == -1 || top == -1 || width == -1); n = n.getParentNode()) {
            String widthStyle;
            String topStyle;
            String leftStyle;
            Map<String, String> attributes = this.styleValues(n.getAttributes());
            if (left == -1 && (leftStyle = attributes.get("left")) != null) {
                left = this.pixelValue(leftStyle);
            }
            if (top == -1 && (topStyle = attributes.get("top")) != null) {
                top = this.pixelValue(topStyle);
            }
            if (width != -1 || (widthStyle = attributes.get("width")) == null) continue;
            width = this.pixelValue(widthStyle);
        }
        Point additionalOffset = result.getAdditionalOffset();
        JComponent component = result.toComponent();
        component.setLocation(Math.max(left, 0) + this.insets.left + additionalOffset.x, Math.max(top, 0) + this.insets.top + additionalOffset.y);
        result.setDivWidth(width);
        component.setSize(component.getPreferredSize());
        return result;
    }

    private int pixelValue(String styleFragment) {
        Matcher m = this.cssPropertyPattern.matcher(styleFragment);
        if (m.matches()) {
            return Integer.parseInt(m.group(1));
        }
        return -1;
    }

    private Map<String, String> styleValues(NamedNodeMap attributes) {
        Node style;
        if (attributes != null && (style = attributes.getNamedItem("style")) != null) {
            String[] props = style.getNodeValue().split(";");
            HashMap<String, String> result = new HashMap<String, String>();
            for (String property : props) {
                String[] split = property.split(":", 2);
                if (split.length == 2) {
                    result.put(split[0], split[1]);
                    continue;
                }
                LogAPI.logWarning((String)("Invalid css property encountered:" + property));
            }
            return result;
        }
        return Collections.emptyMap();
    }

    private EditorWidgetSPI createEditor(String data) {
        String editor;
        String[] getters;
        Map<String, String> map = this.parsePIData(data);
        String path = map.get("path");
        if (path != null) {
            getters = path.split(Pattern.quote("()."));
            String lastString = getters[getters.length - 1];
            if (lastString.endsWith("()")) {
                getters[getters.length - 1] = lastString.substring(0, lastString.length() - 2);
            }
        } else {
            getters = new String[]{};
        }
        String propertyName = map.get("property");
        if (propertyName == null) {
            throw new IllegalArgumentException("Missing property in [" + data + "]");
        }
        ReflectiveProperty property = new ReflectiveProperty(this.message, getters, propertyName);
        switch (editor = map.get("editor")) {
            case "YesNoBox": {
                return new YesNoBox(property, map.get("params"), map.get("tooltip"));
            }
            case "StringCheckBox": {
                return new StringCheckBox(property, map.get("params"));
            }
            case "IntegerPartField": {
                return new IntegerPartField(property);
            }
            case "FractionPartField": {
                return new FractionPartField(property);
            }
            case "IntField": {
                return new IntField(property);
            }
            case "DateField": {
                return new DateField(property, map.get("tooltip"), this.title);
            }
            case "YesBox": {
                return new YesBox(property, map.get("tooltip"));
            }
            case "MoneyField": {
                return new MoneyField((IEditorProperty)property, map.get("tooltip"));
            }
            case "IntegerField": {
                return new IntegerField((IEditorProperty)property, map.get("tooltip"));
            }
        }
        throw new IllegalArgumentException("Uknown editor type [" + editor + "] found in [" + data + "]");
    }
}

