/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.editors;

import com.selima.fbi.core.payebeans.PropertyValidationException;
import com.selima.fbi.ui.common.DatePopupDialog;
import com.selima.fbi.ui.common.SwingHelper;
import com.selima.fbi.ui.content.editors.EditorWidgetSPI;
import com.selima.fbi.ui.content.editors.IEditorProperty;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.JTextComponent;

public class DateField
extends JPanel
implements EditorWidgetSPI,
PropertyChangeListener {
    protected JButton button;
    protected String defaultTooltip;
    protected String popupTitle;
    protected JFormattedTextField textField;
    protected IEditorProperty property;

    public DateField(IEditorProperty property, String toolTip, String popupTitle) {
        super(new BorderLayout(0, 0));
        String tooltipProlog = "Windows".equals(UIManager.getLookAndFeel().getID()) ? "<html><p style='width:250px;padding:10px;margin:0px;'>" : "<html><p style='width:275px;padding:10px;margin:0px;font-size:small;'>";
        this.defaultTooltip = tooltipProlog + toolTip.replaceAll("\n", "<br>") + "</p></html>";
        this.property = property;
        this.popupTitle = popupTitle;
        this.initComponents();
        property.addPropertyChangeListener(this);
        this.setEditorValue((Date)property.get());
    }

    protected void initComponents() {
        this.setOpaque(false);
        this.setFocusable(false);
        this.textField = new JFormattedTextField(new SimpleDateFormat("dd/MM/yyyy"){

            @Override
            public Object parseObject(String source) throws ParseException {
                if (source == null || source.trim().isEmpty()) {
                    return null;
                }
                return super.parseObject(source);
            }
        });
        this.textField.setUI(new BasicTextFieldUI());
        this.textField.setHorizontalAlignment(0);
        if (this.property.isReadonly()) {
            this.textField.setEditable(false);
            this.setBackground(READONLY_BACKGROUND);
        }
        ((DefaultFormatter)this.textField.getFormatter()).setCommitsOnValidEdit(true);
        this.textField.setFocusLostBehavior(0);
        this.textField.setColumns(10);
        this.textField.setToolTipText(this.defaultTooltip);
        this.textField.setForeground(FONT_COLOR);
        this.textField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.textField.setFont(Font.getFont(FONT_STYLE));
        this.add((Component)this.textField, "Center");
        this.textField.addPropertyChangeListener("editValid", this);
        this.textField.addPropertyChangeListener("value", this);
        this.button = new JButton(SwingHelper.imageIcon("/img/16x16/calendar.png"));
        Dimension dim = new Dimension(19, 19);
        this.button.setFocusable(false);
        this.button.setMinimumSize(dim);
        this.button.setPreferredSize(dim);
        this.button.setMaximumSize(dim);
        this.button.setMargin(new Insets(0, 0, 0, 0));
        this.button.setToolTipText(this.defaultTooltip);
        this.button.setFocusable(false);
        this.add((Component)this.button, "East");
        if (this.property.isReadonly()) {
            this.button.setEnabled(false);
        } else {
            this.button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    JFrame frame = (JFrame)SwingUtilities.getWindowAncestor(DateField.this);
                    Date returnValue = new DatePopupDialog(frame, DateField.this.popupTitle).popup(DateField.this.getEditorValue());
                    if (returnValue != null) {
                        DateField.this.setEditorValue(returnValue);
                    }
                }
            });
        }
        this.setMaximumSize(this.getPreferredSize());
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.button.setEnabled(enabled);
        this.textField.setEnabled(enabled);
    }

    public Date getEditorValue() {
        Date date = (Date)this.textField.getValue();
        if (date != null) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(date);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            return calendar.getTime();
        }
        return null;
    }

    public void setEditorValue(Date value) {
        this.textField.setValue(value);
    }

    private void showValid() {
        this.textField.setBackground(DEFAULT_BACKGROUND);
        this.textField.setToolTipText(this.defaultTooltip);
    }

    private void showInvalid(String message) {
        this.textField.setBackground(INVALID_BACKGROUND);
        this.textField.setToolTipText("<html><body style='background:#FFE2E2;color:black;padding:10px;margin:0px;width:275px'>" + message + "</body></html>");
    }

    private void setProperty(Date value) {
        try {
            this.property.set(value);
            this.showValid();
        }
        catch (PropertyValidationException e) {
            this.showInvalid(e.getMessage());
        }
    }

    @Override
    public JComponent toComponent() {
        return this;
    }

    @Override
    public Action[] getPopupActions() {
        return new Action[]{new ResetAction()};
    }

    @Override
    public Point preferredPopupPoint() {
        int x;
        try {
            x = this.textField.getUI().modelToView((JTextComponent)this.textField, (int)this.textField.getCaretPosition()).x;
        }
        catch (Exception e) {
            x = 3;
        }
        int y = this.getHeight() - 3;
        return new Point(x, y);
    }

    @Override
    public boolean isResetable() {
        return this.property.isResetable();
    }

    @Override
    public void resetToPayroll() {
        this.property.reset();
    }

    @Override
    public void detach() {
        this.property.removePropertyChangeListener(this);
    }

    @Override
    public Point getAdditionalOffset() {
        return new Point(0, 0);
    }

    @Override
    public void setDivWidth(int width) {
        Dimension dim = this.getPreferredSize();
        dim.width = width + 30;
        this.setPreferredSize(dim);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if (evt.getSource() == this.textField) {
            if ("editValid".equals(propertyName)) {
                if (Boolean.FALSE == evt.getNewValue()) {
                    if (this.textField.getText().isEmpty()) {
                        this.setProperty(null);
                    } else {
                        this.showInvalid("Must be a date in yyyy-MM-dd format");
                    }
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DateField.this.setProperty(DateField.this.getEditorValue());
                        }
                    });
                }
            } else {
                this.setProperty((Date)evt.getNewValue());
            }
        } else if (!Objects.equals(evt.getNewValue(), this.getEditorValue())) {
            this.setEditorValue((Date)evt.getNewValue());
            if (!this.property.isReadonly()) {
                this.showValid();
            }
        }
    }

    class ResetAction
    extends AbstractAction {
        ResetAction() {
            super("Reset field", SwingHelper.imageIcon("/img/16x16/actions/reset_field.png"));
            this.setEnabled(DateField.this.property.isResetable());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DateField.this.resetToPayroll();
        }
    }
}

