/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.editors;

import com.selima.fbi.core.payebeans.PropertyValidationException;
import com.selima.fbi.ui.content.editors.IEditorProperty;
import com.selima.fbi.ui.content.editors.WrappingProperty;
import java.beans.PropertyChangeEvent;

abstract class BooleanProperty
extends WrappingProperty {
    final Object unselectedValue;
    final Object selectedValue;
    private boolean selfChange;

    BooleanProperty(IEditorProperty editorProperty, String params) {
        super(editorProperty);
        if (params != null) {
            String[] words = params.split(";");
            this.selectedValue = this.convert(words[0]);
            this.unselectedValue = this.convert(words[1]);
        } else {
            this.selectedValue = this.convert("true");
            this.unselectedValue = this.convert("false");
        }
    }

    @Override
    public Boolean get() {
        return (Boolean)super.get();
    }

    @Override
    public void set(Object value) throws PropertyValidationException {
        if (!this.selfChange) {
            super.set(value);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.selfChange = true;
        try {
            super.propertyChange(evt);
        }
        finally {
            this.selfChange = false;
        }
    }

    @Override
    Object toExternal(Object value) {
        return Boolean.TRUE.equals(value) ? this.selectedValue : this.unselectedValue;
    }

    @Override
    Object toInternal(Object value) {
        return this.selectedValue.equals(value);
    }

    abstract Object convert(String var1);
}

