/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.editors;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.html2.HTMLDocument;

public abstract class AbstractPIBasedFactory<ReturnType> {
    final Pattern editorPropertyPattern = Pattern.compile("([^\\s=]+)=(\"([^\"]+)\"|(\\S+))");

    protected abstract ReturnType process(ProcessingInstruction var1);

    protected ReturnType traverse(HTMLDocument document) {
        LinkedList<Object> queue = new LinkedList<Object>();
        queue.add(document);
        do {
            ProcessingInstruction pi;
            ReturnType result;
            Node node;
            if ((node = (Node)queue.remove()) instanceof ProcessingInstruction && (result = this.process(pi = (ProcessingInstruction)node)) != null) {
                return result;
            }
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                queue.add(children.item(i));
            }
        } while (!queue.isEmpty());
        return null;
    }

    protected Map<String, String> parsePIData(String data) {
        Matcher matcher = this.editorPropertyPattern.matcher(data);
        HashMap<String, String> map = new HashMap<String, String>();
        int start = 0;
        while (matcher.find(start)) {
            String key = matcher.group(1);
            String value = matcher.group(3);
            if (value == null) {
                value = matcher.group(4);
            }
            map.put(key, value);
            start = matcher.end();
        }
        return map;
    }
}

