/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.detail.fulltext.queue;

import com.selima.fbi.ui.content.detail.fulltext.queue.ActiveEvent;
import com.selima.fbi.ui.content.detail.fulltext.queue.Event;
import com.selima.fbi.ui.content.detail.fulltext.queue.EventDispatcher;
import com.selima.fbi.ui.content.detail.fulltext.queue.EventListener;
import com.selima.fbi.ui.content.detail.fulltext.queue.EventSource;
import com.selima.framework.threading.CanceledException;
import com.selima.framework.threading.EventBroadcast;
import com.selima.framework.threading.EventBroadcastFactory;

abstract class AbstractDispatcher
implements EventDispatcher {
    protected Thread pullingThread;
    protected EventSource eventSource;
    protected EventBroadcast<EventListener> listeners = EventBroadcastFactory.createEventBroadcast(EventListener.class);

    AbstractDispatcher() {
    }

    @Override
    public void addListener(EventListener listener) {
        this.listeners.addListener((Object)listener);
    }

    @Override
    public void setSource(EventSource eventSource) {
        if (this.eventSource != null) {
            throw new IllegalStateException();
        }
        this.eventSource = eventSource;
    }

    @Override
    public void start() {
        if (this.pullingThread != null) {
            return;
        }
        this.pullingThread = new Thread((Runnable)new PullingRunnable(), this.eventSource.getName() + " Dispatcher");
        this.pullingThread.setPriority(1);
        this.pullingThread.setDaemon(true);
        this.pullingThread.start();
    }

    @Override
    public void stop() {
        if (this.pullingThread != null) {
            this.pullingThread.interrupt();
            this.pullingThread = null;
        }
    }

    abstract void dispatchTemplate(Event var1) throws InterruptedException;

    protected void dispatchInCurrentThread(Event event) throws CanceledException {
        if (event instanceof ActiveEvent) {
            ((ActiveEvent)event).dispatchSelf();
        }
        ((EventListener)this.listeners.getListener()).process(event);
    }

    class PullingRunnable
    implements Runnable {
        PullingRunnable() {
        }

        @Override
        public void run() {
            while (!Thread.interrupted()) {
                try {
                    AbstractDispatcher.this.dispatchTemplate(AbstractDispatcher.this.eventSource.pull());
                }
                catch (CanceledException e) {
                    AbstractDispatcher.this.pullingThread = null;
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                    break;
                }
            }
        }
    }
}

