/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.detail.fulltext.impl;

import com.selima.fbi.ui.content.detail.fulltext.SearchContext;
import com.selima.fbi.ui.content.detail.fulltext.SearchEngine;
import com.selima.fbi.ui.content.detail.fulltext.evt.ChangeEvent;
import com.selima.fbi.ui.content.detail.fulltext.evt.Property;
import com.selima.fbi.ui.content.detail.fulltext.evt.SearchRequestEvent;
import com.selima.fbi.ui.content.detail.fulltext.impl.StopIndexingEvent;
import com.selima.fbi.ui.content.detail.fulltext.impl.StopSearchEvent;
import com.selima.fbi.ui.content.detail.fulltext.queue.EventSink;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

class SearchController
implements PropertyChangeListener,
SearchEngine {
    final EventSink backendSink;
    final SearchContext searchContext;

    SearchController(SearchContext searchContext, EventSink backendSink) {
        this.backendSink = backendSink;
        this.searchContext = searchContext;
        searchContext.addPropertyChangeListener("query", this);
        searchContext.addPropertyChangeListener("currentPage", this);
        searchContext.addPropertyChangeListener("visiblePages", this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("query".equals(propertyName)) {
            this.backendSink.push(new ChangeEvent(Property.QUERY, evt.getNewValue()));
        } else if ("visiblePages".equals(propertyName)) {
            this.backendSink.push(new ChangeEvent(Property.VISIBLE_PAGES, evt.getNewValue()));
        } else if ("currentPage".equals(propertyName) && evt.getNewValue() != null) {
            this.backendSink.push(new ChangeEvent(Property.CURRENT_PAGE, evt.getNewValue()));
        }
    }

    @Override
    public void search() {
        this.backendSink.push(new SearchRequestEvent());
    }

    @Override
    public void start() {
        this.backendSink.push(new ChangeEvent(Property.VISIBLE_PAGES, this.searchContext.getVisiblePages()));
        this.backendSink.push(new ChangeEvent(Property.CURRENT_PAGE, this.searchContext.getCurrentPage()));
        this.backendSink.push(new ChangeEvent(Property.QUERY, this.searchContext.getQuery()));
    }

    @Override
    public void stop() {
        this.backendSink.push(new StopIndexingEvent());
        this.backendSink.push(new StopSearchEvent());
    }
}

