/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.detail.fulltext.impl;

import com.selima.fbi.ui.content.detail.fulltext.evt.ChangeEvent;
import com.selima.fbi.ui.content.detail.fulltext.evt.Property;
import com.selima.fbi.ui.content.detail.fulltext.evt.SearchEvent;
import com.selima.fbi.ui.content.detail.fulltext.impl.Indexer;
import com.selima.fbi.ui.content.detail.fulltext.impl.StopIndexingEvent;
import com.selima.fbi.ui.content.detail.fulltext.queue.ActiveEvent;
import com.selima.fbi.ui.content.detail.fulltext.queue.Event;
import com.selima.fbi.ui.content.detail.fulltext.queue.EventSink;
import com.selima.framework.threading.CanceledException;
import java.util.List;

public class IndexingEvent
extends SearchEvent
implements ActiveEvent {
    final String names;
    final EventSink selfSink;
    IndexingEvent follower;
    final Indexer indexer;
    public final int numOfDocs;

    IndexingEvent(Indexer indexer, EventSink selfSink) {
        this(indexer, selfSink, IndexingEvent.numOfDocs(indexer));
    }

    IndexingEvent(Indexer indexer, EventSink selfSink, int numOfDocs) {
        this.numOfDocs = numOfDocs;
        this.selfSink = selfSink;
        this.indexer = indexer;
        StringBuilder result = new StringBuilder();
        List<String> remaining = indexer.nextDocumentNames(numOfDocs);
        if (remaining.size() > 0) {
            result.append(remaining.get(0));
            if (remaining.size() > 1) {
                result.append(" - ").append(remaining.get(remaining.size() - 1));
            }
        }
        this.names = result.toString();
    }

    @Override
    public String getDescription() {
        return "Indexing " + this.names;
    }

    @Override
    public boolean isSuperseededBy(Event event) {
        if (event instanceof ChangeEvent) {
            ChangeEvent changeEvent = (ChangeEvent)event;
            return changeEvent.property == Property.VISIBLE_PAGES;
        }
        if (event instanceof IndexingEvent) {
            return event != this.follower;
        }
        return event instanceof StopIndexingEvent;
    }

    @Override
    public void dispatchSelf() throws CanceledException {
        for (int i = 0; i < this.numOfDocs && this.indexer.hasMoreDocuments(); ++i) {
            this.checkCancel();
            this.indexer.indexNextDocument();
        }
        this.checkCancel();
        if (this.indexer.hasMoreDocuments()) {
            this.follower = new IndexingEvent(this.indexer, this.selfSink, 1);
            this.selfSink.push(this.follower);
        }
    }

    static int numOfDocs(Indexer indexer) {
        switch (indexer.getCurrentIndexSize()) {
            case 0: {
                return 1;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return 2;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return 5;
            }
        }
        return 10;
    }
}

