/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.detail.fulltext;

import com.selima.fbi.ui.ClientContent;
import com.selima.fbi.ui.common.SwingHelper;
import com.selima.fbi.ui.content.detail.fulltext.SearchContext;
import com.selima.fbi.ui.content.detail.fulltext.SearchEngine;
import com.selima.fbi.ui.content.detail.fulltext.SearchEngineFactory;
import com.selima.fbi.ui.content.detail.fulltext.impl.DefaultSearchEngineFactory;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class FindAction
extends AbstractAction
implements PropertyChangeListener,
AncestorListener {
    static SearchEngineFactory searchEngineFactory = new DefaultSearchEngineFactory();
    SearchContext searchContext;
    SearchEngine searchEngine;

    public FindAction(SearchContext searchContext, ClientContent owner) {
        super("Find", SwingHelper.imageIcon("/img/16x16/actions/mail_find.png"));
        searchContext.addPropertyChangeListener("visiblePages", this);
        searchContext.addPropertyChangeListener("query", this);
        this.searchContext = searchContext;
        this.considerEnablement();
        owner.getContent().addAncestorListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.searchEngine == null) {
            this.searchEngine = searchEngineFactory.create(this.searchContext);
            this.searchEngine.start();
        }
        this.searchEngine.search();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.considerEnablement();
    }

    void considerEnablement() {
        this.setEnabled(this.searchContext.getVisiblePages().size() > 0 && this.searchContext.getQuery() != null && this.searchContext.getQuery().length() > 3);
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        if (this.searchEngine != null) {
            this.searchEngine.start();
        }
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
        if (this.searchEngine != null) {
            this.searchEngine.stop();
        }
    }
}

