/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.detail;

import com.selima.fbi.CancelException;
import com.selima.fbi.core.IDPSMessage;
import com.selima.fbi.plugin.PluginException;
import com.selima.fbi.ui.MailServiceClientContext;
import com.selima.fbi.ui.common.SwingHelper;
import com.selima.fbi.ui.common.waitdlg.MailServiceInterrupter;
import com.selima.fbi.ui.content.MessageBoxContent;
import com.selima.fbi.ui.content.detail.DPSDetailContent;
import com.selima.fbi.ui.content.detail.DeleteAction;
import com.selima.fbi.ui.edialog.FailureDialog;
import com.selima.framework.threading.BackendOperationHandle;
import com.selima.framework.threading.BackendWork;
import com.selima.framework.threading.CanceledException;
import com.selima.framework.threading.SwingOperationHandle;
import com.selima.framework.util.logging.LogAPI;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;

public class TransferDetailContent<T extends IDPSMessage>
extends DPSDetailContent<T> {
    public TransferDetailContent(MailServiceClientContext cctx, MessageBoxContent<T> parentContent, T message) {
        super(cctx, parentContent, message);
        this.toolbar.replace("Delete", new SafeDeleteAction(this, message)).addAfter("Print", new TransferAction());
    }

    private class TransferAction
    extends AbstractAction
    implements BackendWork {
        TransferAction() {
            super("Transfer", SwingHelper.imageIcon("/img/16x16/actions/mail_transfer.png"));
            this.setEnabled(((IDPSMessage)TransferDetailContent.this.message).isTransferrable());
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.setEnabled(false);
            TransferDetailContent.this.getClientContext().getStatusBar().displayMessage(this.getName());
            TransferDetailContent.this.getClientContext().getSubmitter().submitWork((BackendWork)this);
        }

        public String getName() {
            return "Transfering message " + ((IDPSMessage)TransferDetailContent.this.message).getSubject() + " into payroll";
        }

        public void invokeBackend(BackendOperationHandle handle) throws CanceledException {
            TransferDetailContent.this.getClientContext().getStatusBar().setInterrupter(new MailServiceInterrupter(TransferDetailContent.this.getClientContext().getMailService()));
            try {
                ((IDPSMessage)TransferDetailContent.this.message).transfer(true);
            }
            catch (IOException e) {
                handle.setFailure((Throwable)e);
            }
            catch (PluginException e) {
                handle.setFailure((Throwable)e);
            }
            catch (CancelException e) {
                throw new CanceledException((Exception)e);
            }
            finally {
                TransferDetailContent.this.getClientContext().getStatusBar().setInterrupter(null);
            }
        }

        public void invokeSwing(SwingOperationHandle handle) {
            if (handle.getFailure() == null) {
                TransferDetailContent.this.getClientContext().getStatusBar().displayMessage("Transfer accomplished successfully.");
                ((MessageBoxContent)TransferDetailContent.this.parentContent).hideMessage(TransferDetailContent.this.message);
                TransferDetailContent.this.getClientContext().displayContent(TransferDetailContent.this.parentContent);
            } else if (!(handle.getFailure() instanceof CanceledException)) {
                FailureDialog.show(TransferDetailContent.this.getClientContext().getTitle(), "<html>Failed to transfer message<br><b>" + ((IDPSMessage)TransferDetailContent.this.message).getSubject() + "</b><br> into payroll", handle.getFailure());
                LogAPI.logSevere((Throwable)handle.getFailure());
            } else {
                this.setEnabled(((IDPSMessage)TransferDetailContent.this.message).isTransferrable());
            }
        }
    }

    private static class SafeDeleteAction
    extends DeleteAction<T> {
        final /* synthetic */ TransferDetailContent this$0;

        SafeDeleteAction(T message) {
            this.this$0 = var1_1;
            super(var1_1.getClientContext(), message, (MessageBoxContent)var1_1.parentContent);
        }

        @Override
        protected CharSequence createWarningMessage() {
            if (((IDPSMessage)this.message).isTransferrable()) {
                return "<html><p>This message has not been transferred to payroll.</p> Do you really want to delete it?</html>";
            }
            return super.createWarningMessage();
        }
    }
}

