/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.detail;

import com.selima.fbi.ui.content.detail.TabbedPaneSelectionModelContext;
import com.selima.fbi.ui.content.html.PrintingDetails;
import com.selima.fbi.webserver.PagePart;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.DefaultSingleSelectionModel;

final class TabbedPaneSelectionModel
extends DefaultSingleSelectionModel
implements PropertyChangeListener {
    private final TabbedPaneSelectionModelContext tabbedPane;

    TabbedPaneSelectionModel(TabbedPaneSelectionModelContext tabbedPane) {
        this.tabbedPane = tabbedPane;
    }

    @Override
    public void setSelectedIndex(int index) {
        boolean wasBackEnabled = this.tabbedPane.isBackEnabled();
        boolean wasFieldResetable = this.tabbedPane.isFieldResetable();
        boolean wasPageResetable = this.tabbedPane.isPageResetable();
        URL formerURL = this.tabbedPane.getCurrentURL();
        PagePart formerPagePart = this.tabbedPane.getCurrentPage();
        PrintingDetails formerPritingDetails = this.tabbedPane.getPrintingDetails();
        this.detachSelectedComponent();
        super.setSelectedIndex(index);
        this.tabbedPane.firePropertyChange("backEnabled", wasBackEnabled, this.tabbedPane.isBackEnabled());
        this.tabbedPane.firePropertyChange("fieldResetable", wasFieldResetable, this.tabbedPane.isFieldResetable());
        this.tabbedPane.firePropertyChange("pageResetable", wasPageResetable, this.tabbedPane.isPageResetable());
        this.tabbedPane.firePropertyChange("currentURL", formerURL, this.tabbedPane.getCurrentURL());
        this.tabbedPane.firePropertyChange("currentPage", formerPagePart, this.tabbedPane.getCurrentPage());
        this.tabbedPane.firePropertyChange("printingDetails", formerPritingDetails, this.tabbedPane.getPrintingDetails());
        this.attachSelectedComponent();
    }

    @Override
    public void clearSelection() {
        boolean wasBackEnabled = this.tabbedPane.isBackEnabled();
        boolean wasFieldResetable = this.tabbedPane.isFieldResetable();
        boolean wasPageResetable = this.tabbedPane.isPageResetable();
        URL formerURL = this.tabbedPane.getCurrentURL();
        PagePart formerPagePart = this.tabbedPane.getCurrentPage();
        PrintingDetails formerPritingDetails = this.tabbedPane.getPrintingDetails();
        this.detachSelectedComponent();
        super.clearSelection();
        this.tabbedPane.firePropertyChange("backEnabled", wasBackEnabled, this.tabbedPane.isBackEnabled());
        this.tabbedPane.firePropertyChange("fieldResetable", wasFieldResetable, this.tabbedPane.isFieldResetable());
        this.tabbedPane.firePropertyChange("pageResetable", wasPageResetable, this.tabbedPane.isPageResetable());
        this.tabbedPane.firePropertyChange("currentURL", formerURL, this.tabbedPane.getCurrentURL());
        this.tabbedPane.firePropertyChange("currentPage", formerPagePart, this.tabbedPane.getCurrentPage());
        this.tabbedPane.firePropertyChange("printingDetails", formerPritingDetails, this.tabbedPane.getPrintingDetails());
        this.attachSelectedComponent();
    }

    private void detachSelectedComponent() {
        Component selectedComponent = this.tabbedPane.getSelectedComponent();
        if (selectedComponent != null) {
            selectedComponent.removePropertyChangeListener("printingDetails", this);
            selectedComponent.removePropertyChangeListener("backEnabled", this);
            selectedComponent.removePropertyChangeListener("currentURL", this);
            selectedComponent.removePropertyChangeListener("currentPage", this);
            selectedComponent.removePropertyChangeListener("fieldResetable", this);
            selectedComponent.removePropertyChangeListener("pageResetable", this);
        }
    }

    private void attachSelectedComponent() {
        Component selectedComponent = this.tabbedPane.getSelectedComponent();
        if (selectedComponent != null) {
            selectedComponent.addPropertyChangeListener("printingDetails", this);
            selectedComponent.addPropertyChangeListener("backEnabled", this);
            selectedComponent.addPropertyChangeListener("currentURL", this);
            selectedComponent.addPropertyChangeListener("currentPage", this);
            selectedComponent.addPropertyChangeListener("fieldResetable", this);
            selectedComponent.addPropertyChangeListener("pageResetable", this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.tabbedPane.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
    }
}

