/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.detail;

import com.selima.fbi.core.IPAYEMessage;
import com.selima.fbi.ui.MailServiceClientContext;
import com.selima.fbi.ui.common.FlipExpandableLayoutAction;
import com.selima.fbi.ui.common.SwingHelper;
import com.selima.fbi.ui.content.SubmitContent;
import com.selima.fbi.ui.content.detail.AbstractDetailContent;
import com.selima.fbi.ui.content.detail.DetailsPanel;
import com.selima.fbi.ui.content.result.SubmissionContent;
import com.selima.fbi.ui.content.result.ValidationContent;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class SubmitDetailContent
extends AbstractDetailContent<SubmitContent, IPAYEMessage> {
    private IPAYEMessage message;
    private SubmitContent parent;
    private DetailsPanel detailsPanel;

    public SubmitDetailContent(SubmitContent parent, MailServiceClientContext cctx, IPAYEMessage message) {
        super(cctx, parent, message);
        this.parent = parent;
        this.message = message;
        this.setName(message.getSubject());
        this.detailsPanel = new DetailsPanel();
        this.detailsPanel.setMessage(message);
        this.add((Component)this.detailsPanel, "North");
        this.toolbar.addBefore("Save", new FlipExpandableLayoutAction(this.detailsPanel)).addAfter("Print", new SendAction()).addAfter("Print", new ValidateAction());
    }

    @Override
    public String getDescription() {
        return "Message Details";
    }

    @Override
    public String getHelpTopic() {
        return "content.context-help.form-detail";
    }

    class SendAction
    extends AbstractAction {
        SendAction() {
            super("Send", SwingHelper.imageIcon("/img/16x16/actions/redo.png"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            int answer = JOptionPane.showConfirmDialog(SwingUtilities.getWindowAncestor(SubmitDetailContent.this), "Do you want to send the message?", SubmitDetailContent.this.getClientContext().getTitle(), 0, 3);
            if (answer == 0) {
                SubmitDetailContent.this.getClientContext().displayContent(new SubmissionContent(SubmitDetailContent.this.getClientContext(), SubmitDetailContent.this.parent, Collections.singletonList(SubmitDetailContent.this.message)));
            }
        }
    }

    class ValidateAction
    extends AbstractAction {
        ValidateAction() {
            super("Validate", SwingHelper.imageIcon("/img/16x16/validate.png"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SubmitDetailContent.this.getClientContext().displayContent(new ValidationContent(SubmitDetailContent.this.getClientContext(), SubmitDetailContent.this, Collections.singletonList(SubmitDetailContent.this.message)));
        }
    }
}

