/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.detail;

import com.selima.fbi.core.IEASMessage;
import com.selima.fbi.core.IEOYMessage;
import com.selima.fbi.core.IMovMessage;
import com.selima.fbi.core.ININOVRMessage;
import com.selima.fbi.core.IP14PartMessage;
import com.selima.fbi.core.IP35PartMessage;
import com.selima.fbi.core.IPAYEMessage;
import com.selima.fbi.core.IWnuMessage;
import com.selima.fbi.ui.common.ExpandableLayout;
import com.selima.fbi.util.StringUtil;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class DetailsPanel
extends JPanel {
    Format decimalFormat = new DecimalFormat("0.00");

    DetailsPanel() {
        super(new ExpandableLayout());
    }

    void setMessage(IPAYEMessage message) {
        this.add("Employer:", message.getEmpRef());
        if (message instanceof IP14PartMessage) {
            IP14PartMessage p14message = (IP14PartMessage)message;
            this.add("Subject:", p14message.getSubject());
            this.add("Unique ID:", p14message.getUniqueID());
            this.add("P14 Count:", String.valueOf(p14message.getP14Count()));
            this.add("Total Contributions:", this.decimalFormat(p14message.getTotalContributions()));
            this.add("Total Tax:", this.decimalFormat(p14message.getTotalTax()));
        } else if (message instanceof IP35PartMessage) {
            IP35PartMessage p35message = (IP35PartMessage)message;
            this.add("Subject:", p35message.getSubject());
            this.add("Number of Parts:", String.valueOf(p35message.getNumberOfParts()));
            this.add("Total NIC:", this.decimalFormat(p35message.getTotalNIC()));
            this.add("Total Tax:", this.decimalFormat(p35message.getTotalTax()));
        } else if (message instanceof IEOYMessage) {
            IEOYMessage eOYMessage = (IEOYMessage)message;
            this.add("Subject:", eOYMessage.getSubject());
            this.add("P14 Count:", String.valueOf(eOYMessage.getP14Count()));
            this.add("Total NIC:", this.decimalFormat(eOYMessage.getTotalNIC()));
            this.add("Total Tax:", this.decimalFormat(eOYMessage.getTotalTax()));
        } else if (message instanceof IMovMessage) {
            IMovMessage movMessage = (IMovMessage)message;
            this.add("Subject:", movMessage.getSubject());
            this.add("Count:", String.valueOf(movMessage.getCount()));
        } else if (message instanceof IWnuMessage) {
            IWnuMessage wnuMessage = (IWnuMessage)message;
            this.add("Subject:", wnuMessage.getSubject());
            this.add("Record Count:", String.valueOf(wnuMessage.getRecordCount()));
        } else if (message instanceof IEASMessage) {
            this.add("Tax Year:", "20" + StringUtil.taxYearString(message.getTaxYearEnd()));
        } else if (message instanceof ININOVRMessage) {
            this.add("Tax Year:", "20" + StringUtil.taxYearString(message.getTaxYearEnd()));
        }
    }

    String dateFormat(Date date) {
        if (date != null) {
            return DateFormat.getDateTimeInstance().format(date);
        }
        return "";
    }

    String decimalFormat(Number value) {
        if (value != null) {
            return this.decimalFormat.format(value);
        }
        return "";
    }

    void add(String label, String text) {
        this.add(new JLabel(label));
        JTextField fld = new JTextField(text, Math.max(10, text != null ? text.length() : 0));
        fld.setFocusable(false);
        fld.setEditable(false);
        this.add(fld);
    }
}

