/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.detail;

import com.selima.fbi.CancelException;
import com.selima.fbi.core.IDPSMessage;
import com.selima.fbi.core.IPayrollCheckedP6P6BMessage;
import com.selima.fbi.core.IPayrollCheckedP9Message;
import com.selima.fbi.ui.MailServiceClientContext;
import com.selima.fbi.ui.common.ExpandableLayout;
import com.selima.fbi.ui.common.FlipExpandableLayoutAction;
import com.selima.fbi.ui.common.waitdlg.MailServiceInterrupter;
import com.selima.fbi.ui.content.MessageBoxContent;
import com.selima.fbi.ui.content.detail.AbstractDetailContent;
import com.selima.fbi.ui.content.detail.DeleteAction;
import com.selima.framework.threading.BackendOperationHandle;
import com.selima.framework.threading.BackendWork;
import com.selima.framework.threading.CanceledException;
import com.selima.framework.util.logging.LogAPI;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Shape;
import java.io.IOException;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class DPSDetailContent<T extends IDPSMessage>
extends AbstractDetailContent<MessageBoxContent<T>, T> {
    private DetailsPanel detailsPanel = new DetailsPanel();

    public DPSDetailContent(MailServiceClientContext cctx, MessageBoxContent<T> parentContent, T message) {
        super(cctx, parentContent, message);
        this.add((Component)this.detailsPanel, "North");
        this.toolbar.addBefore("Save", new FlipExpandableLayoutAction(this.detailsPanel)).addAfter("Print", new DeleteAction<T>(this.getClientContext(), (IDPSMessage)message, parentContent){
            {
                this.setEnabled(((IDPSMessage)this.message).isDeletable());
            }
        });
    }

    @Override
    protected Insets getHtmlPadding() {
        return new Insets(25, 25, 0, 25);
    }

    @Override
    public BackendWork getOpeningWork() {
        return new AbstractDetailContent.StartingWebServerWork(){

            @Override
            public void invokeBackend(BackendOperationHandle handle) throws CanceledException {
                super.invokeBackend(handle);
                if (!((IDPSMessage)DPSDetailContent.this.message).isRead()) {
                    DPSDetailContent.this.getClientContext().getStatusBar().setInterrupter(new MailServiceInterrupter(DPSDetailContent.this.getClientContext().getMailService()));
                    try {
                        ((IDPSMessage)DPSDetailContent.this.message).markRead();
                    }
                    catch (IOException e) {
                        LogAPI.logSevere((Throwable)e);
                    }
                    catch (CancelException e) {
                        LogAPI.logSevere((Throwable)e);
                    }
                    finally {
                        DPSDetailContent.this.getClientContext().getStatusBar().setInterrupter(null);
                    }
                }
            }
        };
    }

    class BottomBorder
    implements Border {
        final Border wrappedBorder;

        public BottomBorder(Border border) {
            this.wrappedBorder = border;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            Insets insets = this.wrappedBorder.getBorderInsets(c);
            insets.top = 0;
            insets.right = 0;
            insets.left = 0;
            return insets;
        }

        @Override
        public boolean isBorderOpaque() {
            return this.wrappedBorder.isBorderOpaque();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Shape clip = g.getClip();
            try {
                int bottomInset = this.getBorderInsets((Component)c).bottom;
                g.setClip(0, c.getHeight() - bottomInset, c.getWidth(), bottomInset);
                this.wrappedBorder.paintBorder(c, g, x, y, width, height);
            }
            finally {
                g.setClip(clip);
            }
        }
    }

    private class DetailsPanel
    extends JPanel {
        DetailsPanel() {
            super(new ExpandableLayout());
            this.add("Form", ((IDPSMessage)DPSDetailContent.this.message).getFormType().name(), 6);
            this.add("Number", ((IDPSMessage)DPSDetailContent.this.message).getSequenceNumber());
            this.add("Date", ((IDPSMessage)DPSDetailContent.this.message).getIssueDate());
            this.add("Subject", ((IDPSMessage)DPSDetailContent.this.message).getSubject(), 25);
            this.add("Employer", ((IDPSMessage)DPSDetailContent.this.message).getEmpRef(), 10);
            if (DPSDetailContent.this.message instanceof IPayrollCheckedP9Message) {
                this.addPayrollCheckdP9Fields((IPayrollCheckedP9Message)DPSDetailContent.this.message);
            } else if (DPSDetailContent.this.message instanceof IPayrollCheckedP6P6BMessage) {
                this.addPayrollCheckedP6Fields((IPayrollCheckedP6P6BMessage)DPSDetailContent.this.message);
            } else if (((IDPSMessage)DPSDetailContent.this.message).getPayrollWarningMessage() != null) {
                this.add("Warning", ((IDPSMessage)DPSDetailContent.this.message).getPayrollWarningMessage(), 20);
            }
            this.setBorder(new BottomBorder(BorderFactory.createRaisedBevelBorder()));
        }

        private void add(String label, Date value) {
            this.add(label, value != null ? DateFormat.getDateInstance().format(value) : null, 12);
        }

        private void add(String label, long number) {
            this.add(label, Long.toString(number), 11).setHorizontalAlignment(4);
        }

        private void add(String label, Number number) {
            this.add(label, number != null ? NumberFormat.getCurrencyInstance().format(number) : null, 11).setHorizontalAlignment(4);
        }

        private JTextField add(String label, String value, int size) {
            this.add(new JLabel(label));
            JTextField field = new JTextField(value, size);
            field.setEditable(false);
            field.setFocusable(false);
            this.add(field);
            return field;
        }

        private void addPayrollCheckedP6Fields(IPayrollCheckedP6P6BMessage message) {
            this.add("Payroll Previous Pay", message.getPayrollTotalPrevousPay());
            this.add("Payroll Previous Tax", message.getPayrollTotalPrevousTax());
            String payrollTaxCode = message.getPayrollTaxCode();
            if (message.isPayrollWeek1Month1Indicator()) {
                payrollTaxCode = payrollTaxCode + " W1/M1";
            }
            this.add("Payroll Tax Code", payrollTaxCode, 10);
            this.add("Warning ", message.getPayrollWarningMessage(), 20);
        }

        private void addPayrollCheckdP9Fields(IPayrollCheckedP9Message message) {
            String payrollTaxCode = message.getPayrollTaxCode();
            if (message.isPayrollWeek1Month1Indicator()) {
                payrollTaxCode = payrollTaxCode + " W1/M1";
            }
            this.add("Payroll Tax Code", payrollTaxCode, 10);
            this.add("Warning ", message.getPayrollWarningMessage(), 20);
        }
    }
}

