/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.detail;

import com.selima.fbi.core.IMailMessage;
import com.selima.fbi.ui.ClientContent;
import com.selima.fbi.ui.ClientContext;
import com.selima.fbi.ui.MailServiceClientContext;
import com.selima.fbi.ui.common.AbstractSaveAction;
import com.selima.fbi.ui.common.FBIFileChooser;
import com.selima.fbi.ui.common.FormatFileChooser;
import com.selima.fbi.ui.common.PageAndFormatFileChooser;
import com.selima.fbi.ui.common.SwingHelper;
import com.selima.fbi.ui.common.ToolBar;
import com.selima.fbi.ui.common.waitdlg.BackendWorkInterrupter;
import com.selima.fbi.ui.common.waitdlg.BasicInterrupter;
import com.selima.fbi.ui.common.waitdlg.HTMLSaveModel;
import com.selima.fbi.ui.common.waitdlg.SingletonWaitingDialog;
import com.selima.fbi.ui.common.waitdlg.XMLSaveModel;
import com.selima.fbi.ui.content.AbstractClientContent;
import com.selima.fbi.ui.content.PrintAction;
import com.selima.fbi.ui.content.detail.AbstractMessageBrowserContent;
import com.selima.fbi.ui.content.detail.fulltext.FindAction;
import com.selima.fbi.ui.content.detail.fulltext.SearchContext;
import com.selima.fbi.ui.content.detail.fulltext.evt.ErrorEvent;
import com.selima.fbi.ui.content.detail.fulltext.evt.HideProgressBarEvent;
import com.selima.fbi.ui.content.detail.fulltext.evt.NotFoundEvent;
import com.selima.fbi.ui.content.detail.fulltext.evt.PageFoundEvent;
import com.selima.fbi.ui.content.detail.fulltext.evt.ShowProgressBarEvent;
import com.selima.fbi.ui.content.html.PrintHtmlPane;
import com.selima.fbi.ui.content.html.PrintingDetails;
import com.selima.fbi.ui.edialog.FailureDialog;
import com.selima.fbi.ui.export.HTMLExporter;
import com.selima.fbi.ui.export.XMLExporter;
import com.selima.fbi.webserver.PagePart;
import com.selima.fbi.webserver.WebServerException;
import com.selima.framework.threading.BackendOperationHandle;
import com.selima.framework.threading.BackendWork;
import com.selima.framework.threading.CanceledException;
import com.selima.framework.threading.ISubmitter;
import com.selima.framework.threading.SwingOperationHandle;
import com.selima.framework.util.logging.LogAPI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.print.Printable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import sun.swing.PrintingStatus;

abstract class AbstractDetailContent<ParentContentType extends ClientContent, MessageType extends IMailMessage>
extends AbstractMessageBrowserContent<MessageType> {
    protected ParentContentType parentContent;
    protected Map<String, List<PagePart>> pagesPerMode;
    protected MessageType message;
    protected String currentMode;
    protected ToolBar toolbar;
    protected SortBox sortBox;
    protected ModeBox modeBox;
    protected SearchField searchField;

    AbstractDetailContent(MailServiceClientContext cctx, ParentContentType parentContent, MessageType message) {
        super(cctx, message, "/img/32x32/apps/email.png", "Opening Message '" + message.getSubject() + "'");
        this.parentContent = parentContent;
        this.message = message;
        Object[] objectArray = new Object[11];
        objectArray[0] = new SaveAction();
        objectArray[1] = new DetailContentPrintAction();
        objectArray[2] = Box.createHorizontalStrut(5);
        objectArray[3] = new JLabel("Search");
        objectArray[4] = Box.createHorizontalStrut(3);
        this.searchField = new SearchField();
        objectArray[5] = this.searchField;
        final FindAction findAction = new FindAction(new SearchContextImpl(), this);
        objectArray[6] = findAction;
        objectArray[7] = new ResetFieldAction();
        objectArray[8] = new ResetPageAction();
        objectArray[9] = new BackAction();
        objectArray[10] = new CloseAction();
        this.toolbar = new ToolBar(objectArray);
        this.searchField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (findAction.isEnabled()) {
                    findAction.actionPerformed(evt);
                }
            }
        });
    }

    protected List<PagePart> getVisiblePages() {
        return this.pagesPerMode == null ? Collections.emptyList() : this.pagesPerMode.get(this.currentMode);
    }

    @Override
    public ToolBar getToolBar() {
        return this.toolbar;
    }

    @Override
    public String getContentName() {
        return this.message == null ? this.getClass().getSimpleName() : this.message.getSubject();
    }

    @Override
    public String getDescription() {
        return "Message Details";
    }

    @Override
    public String getHelpTopic() {
        return "content.context-help.message-detail";
    }

    @Override
    public BackendWork getOpeningWork() {
        return new StartingWebServerWork();
    }

    @Override
    public BackendWork getClosingWork() {
        return new EndingWebServerWork();
    }

    private void setPages(Map<String, List<PagePart>> pagesPerMode) {
        this.pagesPerMode = pagesPerMode;
        if (!pagesPerMode.containsKey(this.currentMode) && pagesPerMode.size() > 0) {
            this.currentMode = pagesPerMode.keySet().iterator().next();
        }
        if (this.modeBox == null && pagesPerMode.size() > 1) {
            Component[] componentArray = new Component[5];
            componentArray[0] = Box.createHorizontalStrut(5);
            componentArray[1] = new JLabel("Show");
            componentArray[2] = Box.createHorizontalStrut(5);
            this.modeBox = new ModeBox();
            componentArray[3] = this.modeBox;
            componentArray[4] = Box.createHorizontalStrut(5);
            this.getToolBar().addToolAfter("Send", componentArray);
        }
        if (this.modeBox != null) {
            this.modeBox.update();
        }
        if (this.sortBox == null) {
            for (List<PagePart> list : pagesPerMode.values()) {
                if (list.size() <= 1 || list.get(0).getSearchKeys().size() <= 1) continue;
                Component[] componentArray = new Component[5];
                componentArray[0] = Box.createHorizontalStrut(5);
                componentArray[1] = new JLabel("Sort By");
                componentArray[2] = Box.createHorizontalStrut(5);
                this.sortBox = new SortBox();
                componentArray[3] = this.sortBox;
                componentArray[4] = Box.createHorizontalStrut(5);
                this.getToolBar().addToolAfter("Send", componentArray);
            }
        }
        this.showPages(this.currentMode);
    }

    private void showPages(final String mode) {
        this.swapPages(new Runnable(){

            @Override
            public void run() {
                AbstractDetailContent.this.currentMode = mode;
            }
        });
    }

    private void swapPages(Runnable action) {
        PagePart selectedTab = this.getSelectedTab();
        boolean wasBackEnabled = this.isBackEnabled();
        boolean wasFieldResetable = this.isFieldResetable();
        boolean wasPageResetable = this.isPageResetable();
        PrintingDetails formerPrintingDetails = this.getPrintingDetails();
        List<PagePart> formerVisiblePages = this.getVisiblePages();
        this.removeAllTabs();
        this.firePropertyChange("backEnabled", wasBackEnabled, this.isBackEnabled());
        this.firePropertyChange("fieldResetable", wasFieldResetable, this.isFieldResetable());
        this.firePropertyChange("pageResetable", wasPageResetable, this.isPageResetable());
        this.firePropertyChange("printingDetails", formerPrintingDetails, this.getPrintingDetails());
        action.run();
        List<PagePart> pageList = this.getVisiblePages();
        this.setPagesPerTab(Math.max(Math.min(pageList.size() / 50, 30), 10));
        for (PagePart pagePart : pageList) {
            this.addTab(pagePart);
        }
        if (this.sortBox != null) {
            this.sortBox.update();
        }
        if (selectedTab != null) {
            this.setSelectedTab(selectedTab);
        }
        this.firePropertyChange("visiblePages", formerVisiblePages, this.getVisiblePages());
    }

    class SearchContextImpl
    implements SearchContext {
        SearchContextImpl() {
        }

        @Override
        public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
            if ("query".equals(property)) {
                AbstractDetailContent.this.searchField.addPropertyChangeListener("query", listener);
            } else {
                AbstractDetailContent.this.addPropertyChangeListener(property, listener);
            }
        }

        @Override
        public PagePart getCurrentPage() {
            return this.thisContent().getCurrentPage();
        }

        @Override
        public String getQuery() {
            return this.thisContent().searchField.getQuery();
        }

        @Override
        public List<PagePart> getVisiblePages() {
            return this.thisContent().getVisiblePages();
        }

        @Override
        public void foundPageCallback(PageFoundEvent evt) {
            AbstractDetailContent.this.higlight(evt.query, evt.pagePart);
        }

        @Override
        public void hideProgressDialog(HideProgressBarEvent evt) {
            SingletonWaitingDialog.hideDialog();
        }

        @Override
        public void notFoundCallback(NotFoundEvent evt) {
            JOptionPane.showConfirmDialog(this.thisContent(), "<html>No match for <b>'" + evt.query + "'</b></html>", AbstractDetailContent.this.getClientContext().getTitle(), 2, 2);
            AbstractDetailContent.this.higlight(null, null);
        }

        @Override
        public void showProgressDialog(ShowProgressBarEvent evt) {
            SingletonWaitingDialog.showDialog(AbstractDetailContent.this.getClientContext(), evt.progressModel, evt.interrupter);
        }

        @Override
        public void encounteredError(ErrorEvent evt) {
            FailureDialog.show(AbstractDetailContent.this.getClientContext().getTitle(), "<html><b>Full-text search failure</b></html>", evt.error);
        }

        final AbstractDetailContent<?, ?> thisContent() {
            return AbstractDetailContent.this;
        }

        @Override
        public ISubmitter getSubmitter() {
            return AbstractDetailContent.this.getClientContext().getNonCursorSubmitter();
        }
    }

    class ResetPageAction
    extends ComponentAction
    implements PropertyChangeListener {
        ResetPageAction() {
            super("Reset page", "/img/16x16/actions/reset_page.png");
            this.setEnabled(AbstractDetailContent.this.isPageResetable());
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            super.propertyChange(evt);
            this.setEnabled(Boolean.TRUE.equals(evt.getNewValue()));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractDetailContent.this.resetPageToPayroll();
        }
    }

    class ResetFieldAction
    extends ComponentAction
    implements PropertyChangeListener {
        ResetFieldAction() {
            super("Reset field", "/img/16x16/actions/reset_field.png");
            AbstractDetailContent.this.addPropertyChangeListener("fieldResetable", this);
            this.setEnabled(AbstractDetailContent.this.isFieldResetable());
            this.putValue("popupMenu", "hide");
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("fieldResetable".equals(evt.getPropertyName())) {
                this.setEnabled(Boolean.TRUE.equals(evt.getNewValue()));
            }
            super.propertyChange(evt);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractDetailContent.this.resetFieldToPayroll();
        }
    }

    abstract class ComponentAction
    extends AbstractAction
    implements PropertyChangeListener {
        ComponentAction(String name, String iconPath) {
            super(name, SwingHelper.imageIcon(iconPath));
            AbstractDetailContent.this.addPropertyChangeListener("pageResetable", this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("pageResetable".equals(evt.getPropertyName())) {
                this.setVisible(Boolean.TRUE.equals(evt.getNewValue()));
            }
        }

        @Override
        public void putValue(String key, Object newValue) {
            super.putValue(key, newValue);
            if ("component".equals(key)) {
                // empty if block
            }
            this.setVisible(AbstractDetailContent.this.isPageResetable());
        }

        void setVisible(boolean state) {
            JComponent component = (JComponent)this.getValue("component");
            if (component != null) {
                component.setVisible(state);
            }
            super.putValue("visible", state);
        }
    }

    class DetailContentPrintAction
    extends PrintAction {
        String printName;
        URL pageURL;
        PrintingDetails printingDetails;

        public DetailContentPrintAction() {
            super(AbstractDetailContent.this.getClientContext());
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.printName = AbstractDetailContent.this.getSelectedTab().getName();
            this.pageURL = AbstractDetailContent.this.getCurrentURL();
            this.printingDetails = AbstractDetailContent.this.getPrintingDetails();
            super.actionPerformed(evt);
        }

        @Override
        protected String getPrintName() {
            return this.printName;
        }

        @Override
        protected void configurePrinterAttributes(PrintRequestAttributeSet printerAttributes) {
            super.configurePrinterAttributes(printerAttributes);
            printerAttributes.add(this.printingDetails.isLandscape() ? OrientationRequested.LANDSCAPE : OrientationRequested.PORTRAIT);
            this.setMaxAvailableSpace(printerAttributes);
        }

        @Override
        protected Printable createPrintable(PrintingStatus printingStatus, BackendOperationHandle handle) {
            Printable printable = null;
            try {
                PrintHtmlPane printingComponent = new PrintHtmlPane(this.printingDetails);
                printingComponent.setHtmlURL(this.pageURL);
                final JFrame printingFrame = new JFrame("Printing Frame");
                printingFrame.add((Component)((Object)printingComponent));
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        printingFrame.pack();
                    }
                });
                printable = printingStatus.createNotificationPrintable(printingComponent);
            }
            catch (InterruptedException printingComponent) {
            }
            catch (InvocationTargetException e) {
                handle.setFailure(e.getCause());
            }
            return printable;
        }
    }

    static class ClassWarmer
    implements ActionListener,
    BackendWork {
        static volatile boolean warmed;
        final ClientContext context;

        ClassWarmer(ClientContext context) {
            this.context = context;
        }

        static void launch(ClientContext context) {
            if (!warmed) {
                warmed = true;
                Timer timer = new Timer(2000, new ClassWarmer(context));
                timer.setRepeats(false);
                timer.start();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.context.getSubmitter().submitWork((BackendWork)this);
        }

        public String getName() {
            return "Loading Printing infrastructure";
        }

        public void invokeBackend(BackendOperationHandle handle) {
            try {
                Class.forName("java.awt.print.PrinterJob");
                Class.forName("sun.print.ServiceDialog");
                Class.forName("javax.swing.JFileChooser");
            }
            catch (ClassNotFoundException ignored) {
                LogAPI.logWarning((Throwable)ignored);
            }
        }

        public void invokeSwing(SwingOperationHandle handle) {
        }
    }

    class SaveAction
    extends AbstractSaveAction {
        protected SaveAction() {
            super(AbstractDetailContent.this.getClientContext());
        }

        @Override
        protected FBIFileChooser createFileChooser() throws WebServerException {
            FormatFileChooser fileChooser = AbstractDetailContent.this.hasManyParts() ? new PageAndFormatFileChooser() : new FormatFileChooser();
            fileChooser.setProposedBaseName(this.baseName((IMailMessage)AbstractDetailContent.this.message));
            return fileChooser;
        }

        @Override
        protected BackendWorkInterrupter showProgressBar(FBIFileChooser fileChooser) {
            if (fileChooser.isHtml() && fileChooser instanceof PageAndFormatFileChooser) {
                BasicInterrupter interrupter = new BasicInterrupter();
                SingletonWaitingDialog.showDialog(this.clientContext(), new HTMLSaveModel(Collections.singletonList(AbstractDetailContent.this.message)), interrupter);
                return interrupter;
            }
            return null;
        }

        @Override
        protected void hideProgressBar() {
            if (SingletonWaitingDialog.isVisible()) {
                SingletonWaitingDialog.hideDialog();
            }
        }

        @Override
        protected void performSave(FBIFileChooser fileChooser, BackendOperationHandle handle) throws IOException, WebServerException, CanceledException {
            boolean currentOnly = false;
            if (fileChooser instanceof PageAndFormatFileChooser) {
                PageAndFormatFileChooser pafFileChooser = (PageAndFormatFileChooser)fileChooser;
                currentOnly = pafFileChooser.isCurrentOnly();
            }
            boolean xml = fileChooser.isXml();
            File file = fileChooser.getSelectedFile();
            if (file.isDirectory()) {
                file = new File(file, this.baseName((IMailMessage)AbstractDetailContent.this.message));
            }
            xml = this.preferredXml(file, xml);
            file = this.preferredFile(file, xml);
            this.saveFile(xml, currentOnly, file, handle);
        }

        private void saveFile(boolean xml, boolean current, File file, BackendOperationHandle handle) throws IOException, WebServerException, CanceledException {
            AbstractDetailContent.this.getClientContext().getStatusBar().displayMessage("Saving " + file.getPath());
            if (xml) {
                XMLExporter xmlExporter = new XMLExporter(AbstractDetailContent.this.getClientContext().getStatusBar());
                XMLSaveModel xmlProgress = (XMLSaveModel)SingletonWaitingDialog.getProgressModel();
                if (xmlProgress != null) {
                    xmlExporter.addListener(xmlProgress);
                }
                xmlExporter.export((IMailMessage)AbstractDetailContent.this.message, file, handle);
            } else {
                HTMLExporter htmlExporter = new HTMLExporter(AbstractDetailContent.this.getClientContext().getWebServer(), AbstractDetailContent.this.getClientContext().getStatusBar());
                HTMLSaveModel htmlProgress = (HTMLSaveModel)SingletonWaitingDialog.getProgressModel();
                if (htmlProgress != null) {
                    htmlExporter.addListener(htmlProgress);
                }
                if (current) {
                    htmlExporter.export((IMailMessage)AbstractDetailContent.this.message, AbstractDetailContent.this.getSelectedTab(), file, handle);
                } else {
                    htmlExporter.export((IMailMessage)AbstractDetailContent.this.message, AbstractDetailContent.this.currentMode, file, handle);
                }
            }
        }
    }

    class CloseAction
    extends AbstractAction {
        CloseAction() {
            super("Close", SwingHelper.imageIcon("/img/16x16/actions/button_cancel.png"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AbstractDetailContent.this.isBackEnabled()) {
                AbstractDetailContent.this.navigateBack();
            } else {
                AbstractDetailContent.this.getClientContext().displayContent((ClientContent)AbstractDetailContent.this.parentContent);
            }
        }
    }

    class BackAction
    extends AbstractAction
    implements PropertyChangeListener {
        BackAction() {
            super("Back", SwingHelper.imageIcon("/img/16x16/actions/back.png"));
            AbstractDetailContent.this.addPropertyChangeListener("backEnabled", this);
            this.setEnabled(AbstractDetailContent.this.isBackEnabled());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractDetailContent.this.navigateBack();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.setEnabled(Boolean.TRUE.equals(evt.getNewValue()));
        }
    }

    class EndingWebServerWork
    extends AbstractClientContent.OpeningWork {
        EndingWebServerWork() {
        }

        @Override
        public void invokeBackend(BackendOperationHandle handle) {
            try {
                AbstractDetailContent.this.getClientContext().getWebServer().hideMessage((IMailMessage)AbstractDetailContent.this.message);
            }
            catch (WebServerException e) {
                handle.setFailure((Throwable)e);
            }
        }
    }

    protected class StartingWebServerWork
    extends AbstractClientContent.OpeningWork {
        protected StartingWebServerWork() {
        }

        @Override
        public void invokeBackend(BackendOperationHandle handle) throws CanceledException {
            try {
                AbstractDetailContent.this.getClientContext().getWebServer().showMessage((IMailMessage)AbstractDetailContent.this.message);
                Map<String, List<PagePart>> pages = AbstractDetailContent.this.getClientContext().getWebServer().listPages((IMailMessage)AbstractDetailContent.this.message);
                for (List<PagePart> list : pages.values()) {
                    if (list.size() <= 1 || list.get(0).getSearchKeys().size() <= 1) continue;
                    Collections.sort(list);
                }
                handle.setResult(pages);
            }
            catch (WebServerException e) {
                handle.setFailure((Throwable)e);
            }
            catch (IOException e) {
                handle.setFailure((Throwable)e);
            }
        }

        @Override
        public void invokeSwing(SwingOperationHandle handle) {
            if (handle.getFailure() != null) {
                FailureDialog.show(AbstractDetailContent.this.getClientContext().getTitle(), "<html><b>Failed to open message <i>" + AbstractDetailContent.this.message.getSubject() + "</i></b></html>", handle.getFailure());
                LogAPI.logSevere((Throwable)handle.getFailure());
            } else {
                Map pages = (Map)handle.getResult();
                AbstractDetailContent.this.setPages(pages);
                ClassWarmer.launch(AbstractDetailContent.this.getClientContext());
            }
        }
    }

    class SortBox
    extends JComboBox
    implements ItemListener {
        private boolean justUpdating;

        SortBox() {
            this.setEditable(false);
            this.addItemListener(this);
            this.setName("Sort By");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void update() {
            this.justUpdating = true;
            try {
                PagePart pagePart;
                Set<String> searchKeys;
                List<PagePart> visiblePages = AbstractDetailContent.this.getVisiblePages();
                Vector<String> sortKeys = new Vector<String>();
                String currentKey = null;
                if (visiblePages.size() > 1 && (searchKeys = (pagePart = visiblePages.get(0)).getSearchKeys()).size() > 1) {
                    sortKeys.addAll(searchKeys);
                    currentKey = pagePart.getCurrentSearchKey();
                }
                this.setModel(new DefaultComboBoxModel(sortKeys));
                this.setSelectedItem(currentKey);
                this.setEnabled(sortKeys.size() > 1);
            }
            finally {
                this.justUpdating = false;
            }
        }

        @Override
        public Dimension getMaximumSize() {
            Dimension result = this.getPreferredSize();
            return result;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension result = super.getPreferredSize();
            result.width = Math.max(result.width, 64);
            return result;
        }

        @Override
        public void itemStateChanged(ItemEvent evt) {
            if (this.justUpdating || evt.getStateChange() == 2) {
                return;
            }
            final String searchIndex = (String)this.getSelectedItem();
            final List<PagePart> pages = AbstractDetailContent.this.getVisiblePages();
            AbstractDetailContent.this.getClientContext().getSubmitter().submitWork(new BackendWork(){

                public String getName() {
                    return "Sorting Pages";
                }

                public void invokeBackend(BackendOperationHandle handle) {
                    ArrayList sortedPages = new ArrayList(pages);
                    ListIterator<PagePart> it = sortedPages.listIterator();
                    while (it.hasNext()) {
                        it.set(((PagePart)it.next()).applyKey(searchIndex));
                    }
                    Collections.sort(sortedPages);
                    handle.setResult(sortedPages);
                }

                public void invokeSwing(SwingOperationHandle handle) {
                    final List sortedPages = (List)handle.getResult();
                    AbstractDetailContent.this.swapPages(new Runnable(){

                        @Override
                        public void run() {
                            AbstractDetailContent.this.pagesPerMode.put(AbstractDetailContent.this.currentMode, sortedPages);
                        }
                    });
                }
            });
        }
    }

    class ModeBox
    extends JComboBox
    implements ItemListener {
        private boolean justUpdating;

        ModeBox() {
            this.setEditable(false);
            this.addItemListener(this);
            this.setRenderer(new ModeRenderer());
        }

        @Override
        public Dimension getMaximumSize() {
            Dimension result = this.getPreferredSize();
            return result;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension result = super.getPreferredSize();
            result.width = Math.max(result.width, 64);
            return result;
        }

        void update() {
            this.justUpdating = true;
            try {
                this.setModel(new DefaultComboBoxModel<String>(new Vector<String>(AbstractDetailContent.this.pagesPerMode.keySet())));
                this.setSelectedItem(AbstractDetailContent.this.currentMode);
            }
            finally {
                this.justUpdating = false;
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (!this.justUpdating) {
                AbstractDetailContent.this.showPages((String)e.getItem());
            }
        }

        class ModeRenderer
        extends DefaultListCellRenderer {
            ModeRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (String.valueOf(value).matches("/templates/PAYE/P35\\(\\d+\\)\\.xsl")) {
                    value = "Cont.Sheets";
                } else if (String.valueOf(value).matches("/templates/PAYE/P14\\(\\d+\\)\\.xsl")) {
                    value = "P14s";
                }
                return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
        }
    }

    class SearchField
    extends JTextField {
        String query;

        public SearchField() {
            super(8);
            AbstractDocument document = (AbstractDocument)this.getDocument();
            document.setDocumentFilter(new ModificationFilter());
            this.getInputMap(2).put(KeyStroke.getKeyStroke("F3"), "search-next");
            this.getActionMap().put("search-next", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SearchField.this.fireActionPerformed();
                }
            });
        }

        public String getQuery() {
            return this.query;
        }

        public void setQuery(String query) {
            String oldValue = this.query;
            this.query = query;
            this.firePropertyChange("query", oldValue, query);
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        class ModificationFilter
        extends DocumentFilter {
            ModificationFilter() {
            }

            @Override
            public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
                super.insertString(fb, offset, string, attr);
                SearchField.this.setQuery(fb.getDocument().getText(0, fb.getDocument().getLength()));
            }

            @Override
            public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
                super.remove(fb, offset, length);
                SearchField.this.setQuery(fb.getDocument().getText(0, fb.getDocument().getLength()));
            }

            @Override
            public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
                super.replace(fb, offset, length, text, attrs);
                SearchField.this.setQuery(fb.getDocument().getText(0, fb.getDocument().getLength()));
            }
        }
    }
}

